/*
 * Decompiled with CFR 0.152.
 */
package com.ning.metrics.meteo.publishers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.codehaus.jackson.annotate.JsonTypeInfo;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, include=JsonTypeInfo.As.PROPERTY, property="@class")
public class PublisherConfig {
    private String name;
    private String type;
    private List<Pattern> filters = new ArrayList<Pattern>();
    private String timeAttribute = "timestamp";

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public List<Pattern> getFilters() {
        return Collections.unmodifiableList(this.filters);
    }

    public void setFilters(List<String> filters) {
        this.filters.clear();
        for (String filter : filters) {
            this.filters.add(Pattern.compile(filter));
        }
    }

    public boolean isIncluded(String str) {
        if (this.filters.isEmpty()) {
            return true;
        }
        for (Pattern pattern : this.filters) {
            if (!pattern.matcher(str).matches()) continue;
            return true;
        }
        return false;
    }

    public String getTimeAttribute() {
        return this.timeAttribute;
    }

    public void setTimeAttribute(String timeAttribute) {
        this.timeAttribute = timeAttribute;
    }
}

