/*
 * Decompiled with CFR 0.152.
 */
package com.ning.metrics.meteo.publishers;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.UpdateListener;
import com.ning.metrics.meteo.publishers.EsperListener;
import com.ning.metrics.meteo.publishers.OpenTSDBPublisher;
import com.ning.metrics.meteo.publishers.OpenTSDBPublisherConfig;

class OpenTSDBListener
extends EsperListener
implements UpdateListener {
    private final OpenTSDBPublisherConfig config;
    private final OpenTSDBPublisher publisher;

    public OpenTSDBListener(OpenTSDBPublisherConfig config) {
        this.config = config;
        this.publisher = new OpenTSDBPublisher(config);
        this.publisher.failSafeConnect();
    }

    public void update(EventBean[] newEvents, EventBean[] oldEvents) {
        if (newEvents != null) {
            for (EventBean newEvent : newEvents) {
                String typeName = OpenTSDBListener.getEventName(newEvent);
                Long timeInMs = OpenTSDBListener.getEventMillis(newEvent, this.config.getTimeAttribute());
                for (String attribute : newEvent.getEventType().getPropertyNames()) {
                    Object value;
                    String fullName;
                    String string = fullName = typeName == null ? attribute : typeName + "." + attribute;
                    if (!this.config.isIncluded(fullName) || (value = newEvent.get(attribute)) == null) continue;
                    this.publisher.send(this.config.getPrefix() + "." + attribute, timeInMs, value);
                }
            }
        }
    }
}

