/*
 * Decompiled with CFR 0.152.
 */
package com.ning.metrics.meteo.publishers;

import com.ning.metrics.meteo.publishers.GraphitePublisherConfig;
import java.io.IOException;
import java.io.PrintStream;
import java.net.Socket;
import org.apache.log4j.Logger;

class GraphitePublisher {
    private static final Logger log = Logger.getLogger(GraphitePublisher.class);
    private GraphitePublisherConfig config;
    private Socket socket;

    public GraphitePublisher(GraphitePublisherConfig config) {
        this.config = config;
    }

    public void send(String metric, Object value) {
        try {
            String m = String.format("%s %s %d", metric, value, System.currentTimeMillis() / 1000L);
            PrintStream ps = new PrintStream(this.socket.getOutputStream());
            ps.println(m);
            log.debug((Object)String.format("Sent to Graphite: %s", m));
        }
        catch (IOException e) {
            log.warn((Object)"Dropping event - unable to send data to Graphite", (Throwable)e);
            this.failSafeConnect();
        }
    }

    public void connect() throws IOException {
        this.socket = new Socket(this.config.getHost(), (int)this.config.getPort());
    }

    public void disconnect() throws IOException {
        if (this.socket != null) {
            this.socket.close();
        }
    }

    public void failSafeConnect() {
        this.failSafeConnect(1000, 10000);
    }

    public void failSafeConnect(int initialBackoffTime, int maxBackoffTime) {
        int backoffTime = initialBackoffTime;
        try {
            this.disconnect();
        }
        catch (IOException e) {
            log.debug((Object)"Exception trying to close an already broken connection", (Throwable)e);
        }
        try {
            log.info((Object)"Attempting to connect to Graphite");
            this.connect();
            return;
        }
        catch (IOException e) {
            log.warn((Object)("Unable to connect to Graphite. Will retry in " + backoffTime + " ms"), (Throwable)e);
            try {
                this.disconnect();
            }
            catch (IOException e2) {
                log.debug((Object)"Exception trying to close an already broken connection", (Throwable)e2);
            }
            try {
                Thread.sleep(backoffTime);
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
            }
            if ((backoffTime *= 2) > maxBackoffTime) {
                backoffTime = maxBackoffTime;
            }
            this.failSafeConnect(backoffTime, maxBackoffTime);
            return;
        }
    }
}

