/*
 * Decompiled with CFR 0.152.
 */
package com.ning.metrics.meteo.publishers;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.UpdateListener;
import com.ning.metrics.meteo.publishers.EsperListener;
import com.ning.metrics.meteo.publishers.FilePublisherConfig;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import org.apache.log4j.Logger;

class FileListener
extends EsperListener
implements UpdateListener {
    private static final Logger log = Logger.getLogger(FileListener.class);
    private final FilePublisherConfig config;
    private PrintWriter writer = null;

    public FileListener(FilePublisherConfig config) {
        this.config = config;
        try {
            if (config.getPath() == null) {
                throw new IOException("File path not specified!");
            }
            this.writer = new PrintWriter(new FileWriter(config.getPath()));
        }
        catch (IOException e) {
            log.warn((Object)String.format("Unable to write to %s, file publisher disabled", config.getPath()));
        }
    }

    public void update(EventBean[] newEvents, EventBean[] oldEvents) {
        if (newEvents != null && this.writer != null) {
            StringBuilder builder = new StringBuilder();
            for (EventBean newEvent : newEvents) {
                String typeName = FileListener.getEventName(newEvent);
                builder.setLength(0);
                for (String attribute : newEvent.getEventType().getPropertyNames()) {
                    String fullName;
                    String string = fullName = typeName == null ? attribute : typeName + "." + attribute;
                    if (!this.config.isIncluded(fullName)) continue;
                    Object value = newEvent.get(attribute);
                    builder.append(FileListener.getEventMillis(newEvent, this.config.getTimeAttribute()));
                    builder.append(this.config.getSeparator());
                    builder.append(fullName);
                    builder.append(this.config.getSeparator());
                    if (value == null) {
                        builder.append("null");
                    } else if (value instanceof String) {
                        builder.append('\"');
                        builder.append(value);
                        builder.append('\"');
                    } else {
                        builder.append(value);
                    }
                    builder.append("\n");
                }
                if (builder.length() <= 0) continue;
                this.writer.print(builder.toString());
                this.writer.flush();
            }
        }
    }
}

