/*
 * Decompiled with CFR 0.152.
 */
package com.ning.metrics.meteo.publishers;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.UpdateListener;
import com.ning.metrics.meteo.publishers.DebugPublisherConfig;
import com.ning.metrics.meteo.publishers.EsperListener;
import org.apache.log4j.Logger;

class DebugListener
extends EsperListener
implements UpdateListener {
    private static final Logger log = Logger.getLogger(DebugListener.class);
    private final DebugPublisherConfig config;

    public DebugListener(DebugPublisherConfig config) {
        this.config = config;
    }

    public void update(EventBean[] newEvents, EventBean[] oldEvents) {
        if (newEvents != null) {
            StringBuilder builder = new StringBuilder();
            for (EventBean newEvent : newEvents) {
                String typeName = DebugListener.getEventName(newEvent);
                builder.setLength(0);
                for (String attribute : newEvent.getEventType().getPropertyNames()) {
                    String fullName;
                    String string = fullName = typeName == null ? attribute : typeName + "." + attribute;
                    if (!this.config.isIncluded(fullName)) continue;
                    Object value = newEvent.get(attribute);
                    builder.append("\n  ");
                    builder.append(fullName);
                    builder.append("=");
                    if (value == null) {
                        builder.append("null");
                        continue;
                    }
                    if (value instanceof String) {
                        builder.append('\"');
                        builder.append(value);
                        builder.append('\"');
                        continue;
                    }
                    builder.append(value);
                }
                if (builder.length() <= 0) continue;
                log.info((Object)builder.toString());
            }
        }
    }
}

