/*
 * Decompiled with CFR 0.152.
 */
package com.ning.metrics.meteo.publishers;

import com.ning.http.client.AsyncCompletionHandler;
import com.ning.http.client.AsyncHandler;
import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.AsyncHttpClientConfig;
import com.ning.http.client.Response;
import com.ning.metrics.meteo.publishers.AreciboPublisherConfig;
import java.io.IOException;
import java.util.Map;
import java.util.UUID;
import org.apache.log4j.Logger;
import org.codehaus.jackson.map.ObjectMapper;

class AreciboPublisher {
    private static final Logger log = Logger.getLogger(AreciboPublisher.class);
    private static final ObjectMapper mapper = new ObjectMapper();
    private final AreciboPublisherConfig config;
    private final AsyncHttpClient asyncSender;
    public static final String HEADER_CONTENT_TYPE = "Content-type";
    public static final String CONTENT_TYPE = "application/json";
    public static final String API_PATH = "/xn/rest/1.0/event";

    public AreciboPublisher(AreciboPublisherConfig config) {
        this.config = config;
        AsyncHttpClientConfig.Builder builder = new AsyncHttpClientConfig.Builder();
        builder.setMaximumConnectionsPerHost(-1);
        this.asyncSender = new AsyncHttpClient(builder.build());
    }

    public void send(String metric, Map<String, Object> value) {
        try {
            this.publish(metric, this.convertToRealtimeEvent(metric, value));
        }
        catch (IOException e) {
            log.warn((Object)("Error sending event to Arecibo: " + e.getLocalizedMessage()));
        }
    }

    private Map<String, Object> convertToRealtimeEvent(String eventType, Map<String, Object> attributes) {
        attributes.put("sourceUUID", UUID.randomUUID());
        attributes.put("timestamp", System.currentTimeMillis());
        attributes.put("eventType", eventType);
        return attributes;
    }

    private void publish(String eventType, Map<String, Object> event) throws IOException {
        this.asyncSender.preparePost(String.format("http://%s:%d%s", this.config.getHost(), this.config.getPort(), API_PATH)).addHeader(HEADER_CONTENT_TYPE, CONTENT_TYPE).setBody(mapper.writeValueAsBytes(event)).execute((AsyncHandler)new AsyncCompletionHandler<Integer>(){

            public Integer onCompleted(Response response) throws Exception {
                if (response.getStatusCode() >= 300) {
                    log.warn((Object)("Unexpected response from Arecibo: " + response.getStatusText()));
                }
                return response.getStatusCode();
            }

            public void onThrowable(Throwable t) {
                log.warn((Object)t);
            }
        });
    }
}

