/*
 * Decompiled with CFR 0.152.
 */
package com.ning.metrics.meteo.publishers;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.UpdateListener;
import com.ning.metrics.meteo.publishers.AlertPublisherConfig;
import com.ning.metrics.meteo.publishers.EsperListener;
import java.util.Arrays;
import javax.mail.internet.InternetAddress;
import org.apache.commons.mail.HtmlEmail;
import org.apache.log4j.Logger;

class AlertListener
extends EsperListener
implements UpdateListener {
    private static final Logger log = Logger.getLogger(AlertListener.class);
    private final AlertPublisherConfig config;

    public AlertListener(AlertPublisherConfig config) {
        this.config = config;
    }

    public void update(EventBean[] newEvents, EventBean[] oldEvents) {
        if (newEvents != null) {
            for (EventBean newEvent : newEvents) {
                Double result1 = (Double)newEvent.get("result1");
                if (result1 == null) continue;
                this.createAndSendAlertEmail(String.format("Boo ! Result " + result1, new Object[0]));
            }
        }
    }

    private void createAndSendAlertEmail(String body) {
        try {
            log.info((Object)String.format("Sending alert email to [%s]: %s", this.config.getRecipients(), body));
            HtmlEmail email = new HtmlEmail();
            email.setTextMsg(body);
            email.setFrom("esper-is-awesome@example.com");
            email.setTo(Arrays.asList(new InternetAddress(this.config.getRecipients())));
            email.setHostName(this.config.getHost());
            email.setSmtpPort(this.config.getPort().intValue());
            email.send();
        }
        catch (Exception ex) {
            log.warn((Object)"Could not create or send email", (Throwable)ex);
        }
    }
}

