/*
 * Decompiled with CFR 0.152.
 */
package com.ning.metrics.meteo.publishers;

import com.ning.metrics.meteo.publishers.AMQConnection;
import com.ning.metrics.meteo.publishers.AMQPublisherConfig;
import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.TimerMetric;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.jms.BytesMessage;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import org.apache.activemq.AlreadyClosedException;
import org.apache.activemq.ConnectionFailedException;
import org.apache.log4j.Logger;

public class AMQSession {
    private static final Logger logger = Logger.getLogger(AMQSession.class);
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private final TimerMetric timer;
    private final AMQPublisherConfig config;
    private final AMQConnection connection;
    private final String topic;
    private final AtomicBoolean isRunning = new AtomicBoolean(false);
    private final AtomicBoolean useBytesMessage;
    private final Object sessionMonitor = new Object();
    private TopicSession session = null;
    private TopicPublisher publisher;

    public AMQSession(AMQPublisherConfig config, AMQConnection connection, String topic, AtomicBoolean useBytesMessage) {
        this.config = config;
        this.connection = connection;
        this.topic = topic;
        this.useBytesMessage = useBytesMessage;
        this.timer = Metrics.newTimer(AMQSession.class, (String)topic, (TimeUnit)TimeUnit.MILLISECONDS, (TimeUnit)TimeUnit.SECONDS);
        this.reinit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.isRunning.get()) {
            Object object = this.sessionMonitor;
            synchronized (object) {
                this.isRunning.set(false);
                if (this.publisher != null) {
                    try {
                        this.publisher.close();
                    }
                    catch (JMSException ex) {
                        logger.warn((Object)String.format("Got error while trying to close a producer for topic %s", this.topic), (Throwable)ex);
                    }
                    this.publisher = null;
                }
                if (this.session != null) {
                    try {
                        this.session.close();
                    }
                    catch (JMSException ex) {
                        logger.warn((Object)String.format("Got error while trying to close a session for topic %s", this.topic), (Throwable)ex);
                    }
                    this.session = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reinit() {
        long startTime = System.currentTimeMillis();
        Object object = this.sessionMonitor;
        synchronized (object) {
            this.close();
            while (!this.isRunning.get()) {
                try {
                    this.session = this.connection.createTopicSession();
                    this.publisher = this.session.createPublisher(this.session.createTopic(this.topic));
                    this.publisher.setDeliveryMode(1);
                    this.publisher.setTimeToLive(this.config.getMessagesTTLMilliseconds());
                    this.isRunning.set(true);
                }
                catch (JMSException ex) {
                    logger.debug((Object)String.format("Got error while trying to get a session for topic %s", this.topic));
                }
            }
        }
        long secondsToRecreate = (System.currentTimeMillis() - startTime) / 1000L;
        logger.info((Object)String.format("Recreated topic [%s] in %d seconds", this.topic, secondsToRecreate));
    }

    private boolean shouldReinit(JMSException ex) {
        return ex instanceof AlreadyClosedException || ex instanceof IllegalStateException || ex instanceof ConnectionFailedException || ex.getCause() instanceof IOException;
    }

    public void send(Object event) {
        if (this.isRunning.get()) {
            try {
                long startTime = System.nanoTime();
                this.publisher.send(this.createMessage(event));
                this.timer.update(System.nanoTime() - startTime, TimeUnit.NANOSECONDS);
            }
            catch (JMSException ex) {
                if (this.shouldReinit(ex)) {
                    this.reinit();
                }
                logger.debug((Object)String.format("Got error while trying to send a message to topic %s", this.topic));
            }
        }
    }

    protected Message createMessage(Object event) throws JMSException {
        String eventStr = event.toString();
        if (this.useBytesMessage.get()) {
            BytesMessage msg = this.session.createBytesMessage();
            msg.writeBytes(eventStr.getBytes(UTF8));
            return msg;
        }
        return this.session.createTextMessage(eventStr);
    }
}

