/*
 * Decompiled with CFR 0.152.
 */
package com.ning.metrics.meteo.publishers;

import com.ning.metrics.meteo.publishers.AMQConnection;
import com.ning.metrics.meteo.publishers.AMQPublisherConfig;
import com.ning.metrics.meteo.publishers.AMQSession;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.codehaus.jackson.map.ObjectMapper;

class AMQPublisher {
    private static final Logger log = Logger.getLogger(AMQPublisher.class);
    private static final ObjectMapper mapper = new ObjectMapper();
    private final Map<String, AMQSession> sessionsPerType = new HashMap<String, AMQSession>();
    private final Object queueMapMonitor = new Object();
    private final AMQPublisherConfig config;
    private final AMQConnection connection;

    public AMQPublisher(AMQPublisherConfig config) {
        this.config = config;
        this.connection = new AMQConnection(config);
    }

    public void send(String metric, Map<String, Object> value) {
        try {
            this.publish(metric, value);
        }
        catch (IOException e) {
            log.warn((Object)("Error sending event to AMQ: " + e.getLocalizedMessage()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void publish(String eventType, Map<String, Object> event) throws IOException {
        AMQSession session = this.sessionsPerType.get(eventType);
        if (session == null) {
            Object object = this.queueMapMonitor;
            synchronized (object) {
                session = this.sessionsPerType.get(eventType);
                if (session == null) {
                    session = this.connection.getSessionFor(eventType, this.config);
                    this.sessionsPerType.put(eventType, session);
                }
            }
        }
        session.send(mapper.writeValueAsBytes(event));
    }
}

