/*
 * Decompiled with CFR 0.152.
 */
package com.ning.metrics.meteo.publishers;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.UpdateListener;
import com.ning.metrics.meteo.publishers.AMQPublisher;
import com.ning.metrics.meteo.publishers.AMQPublisherConfig;
import com.ning.metrics.meteo.publishers.EsperListener;
import java.util.HashMap;
import java.util.Map;

class AMQListener
extends EsperListener
implements UpdateListener {
    private final AMQPublisherConfig config;
    private final AMQPublisher publisher;

    public AMQListener(AMQPublisherConfig config) {
        this.config = config;
        this.publisher = new AMQPublisher(config);
    }

    public void update(EventBean[] newEvents, EventBean[] oldEvents) {
        if (newEvents != null) {
            for (EventBean newEvent : newEvents) {
                this.publisher.send(this.config.getPrefix(), AMQListener.toMap(newEvent));
            }
        }
    }

    private static Map<String, Object> toMap(EventBean bean) {
        HashMap<String, Object> res = new HashMap<String, Object>();
        for (String attribute : bean.getEventType().getPropertyNames()) {
            res.put(attribute, bean.get(attribute));
        }
        return res;
    }
}

