/*
 * Decompiled with CFR 0.152.
 */
package com.ning.metrics.meteo.publishers;

import com.ning.metrics.meteo.publishers.AMQPublisherConfig;
import com.ning.metrics.meteo.publishers.AMQSession;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.jms.JMSException;
import javax.jms.TopicConnection;
import javax.jms.TopicSession;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.log4j.Logger;

public class AMQConnection {
    private static final Logger logger = Logger.getLogger(AMQConnection.class);
    private ActiveMQConnectionFactory connectionFactory = null;
    private final Object connectionMonitor = new Object();
    private TopicConnection connection = null;
    private final AtomicBoolean useBytesMessage;

    public AMQConnection(AMQPublisherConfig baseConfig) {
        this.useBytesMessage = new AtomicBoolean(baseConfig.getUseBytesMessage());
        String uri = baseConfig.getUri();
        if (uri != null) {
            this.connectionFactory = new ActiveMQConnectionFactory(uri);
            this.connectionFactory.setUseAsyncSend(baseConfig.getUseAsyncSend().booleanValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reconnect() {
        long startTime = System.currentTimeMillis();
        if (this.connectionFactory == null) {
            logger.warn((Object)"Asked to reconnect to AMQ but no connectionFactory was configured!");
            return;
        }
        Object object = this.connectionMonitor;
        synchronized (object) {
            this.close();
            int numTries = 0;
            int pauseInMs = 100;
            boolean connected = false;
            while (!connected) {
                ++numTries;
                try {
                    this.connection = this.connectionFactory.createTopicConnection();
                    this.connection.start();
                    connected = true;
                }
                catch (JMSException ex) {
                    logger.warn((Object)"Got error while trying to connect to activemq");
                    try {
                        Thread.sleep(pauseInMs);
                    }
                    catch (InterruptedException innerEx) {
                        Thread.currentThread().interrupt();
                        return;
                    }
                    if (numTries >= 10) continue;
                    pauseInMs += pauseInMs;
                }
            }
        }
        long secondsToReconnect = (System.currentTimeMillis() - startTime) / 1000L;
        logger.info((Object)String.format("Reconnected to AMQ in %d seconds", secondsToReconnect));
    }

    public AMQSession getSessionFor(String type, AMQPublisherConfig config) {
        return new AMQSession(config, this, type, this.useBytesMessage);
    }

    TopicSession createTopicSession() {
        TopicSession result = null;
        while (result == null) {
            try {
                result = this.connection.createTopicSession(false, 1);
            }
            catch (JMSException ex) {
                this.reconnect();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.connectionMonitor;
        synchronized (object) {
            if (this.connection != null) {
                try {
                    this.connection.close();
                }
                catch (JMSException ex) {
                    logger.error((Object)"Error while closing the connection to ActiveMQ", (Throwable)ex);
                }
                this.connection = null;
            }
        }
    }
}

