/*
 * Decompiled with CFR 0.152.
 */
package com.ning.metrics.meteo.esper;

import com.espertech.esper.collection.SortedDoubleVector;
import com.espertech.esper.epl.agg.AggregationSupport;
import com.espertech.esper.epl.agg.AggregationValidationContext;
import org.apache.log4j.Logger;

public class TPAggregator
extends AggregationSupport {
    private final Logger log = Logger.getLogger(TPAggregator.class);
    private SortedDoubleVector vector = new SortedDoubleVector();
    private int percentile;

    public void clear() {
        this.vector.clear();
    }

    public void validate(AggregationValidationContext validationContext) {
        if (!validationContext.getParameterTypes()[0].isAssignableFrom(Integer.class)) {
            throw new IllegalArgumentException("TPAggregator takes only numerical arguments");
        }
    }

    public void enter(Object object) {
        if (object == null) {
            return;
        }
        Object[] params = (Object[])object;
        this.percentile = (Integer)params[0];
        try {
            double value = Double.parseDouble(params[1].toString());
            this.vector.add(value);
        }
        catch (ClassCastException ex) {
            this.log.debug((Object)ex);
        }
    }

    public void leave(Object object) {
        if (object == null) {
            return;
        }
        Object[] params = (Object[])object;
        try {
            double value = Double.parseDouble(params[1].toString());
            this.vector.remove(value);
        }
        catch (IllegalStateException ex) {
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    public Object getValue() {
        int nbElements = this.vector.size();
        if (nbElements == 0) {
            return null;
        }
        double rank = (double)this.percentile / 100.0 * (double)(nbElements - 1) + 1.0;
        int k = (int)rank;
        double d = rank - (double)k;
        if (k == 0) {
            return this.vector.getValue(0);
        }
        if (k == nbElements) {
            return this.vector.getValue(nbElements - 1);
        }
        return this.vector.getValue(k - 1) + d * (this.vector.getValue(k) - this.vector.getValue(k - 1));
    }

    public Class getValueType() {
        return Double.class;
    }
}

