/*
 * Decompiled with CFR 0.152.
 */
package com.ning.metrics.meteo.esper;

import com.espertech.esper.client.EventType;
import com.espertech.esper.core.StatementContext;
import com.espertech.esper.epl.core.ViewResourceCallback;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.util.JavaClassHelper;
import com.espertech.esper.view.View;
import com.espertech.esper.view.ViewCapability;
import com.espertech.esper.view.ViewFactory;
import com.espertech.esper.view.ViewFactoryContext;
import com.espertech.esper.view.ViewFactorySupport;
import com.espertech.esper.view.ViewParameterException;
import com.ning.metrics.meteo.esper.HoltWinters;
import java.util.Arrays;
import java.util.List;

public class HoltWintersViewFactory
implements ViewFactory {
    private ExprNode fieldName;
    private double alpha;
    private double beta = Double.MIN_VALUE;
    private double gamma = Double.MIN_VALUE;
    private int period;
    private EventType eventType;

    public void setViewParameters(ViewFactoryContext context, List<ExprNode> viewParameters) throws ViewParameterException {
        this.fieldName = viewParameters.get(0);
        List evaluated = ViewFactorySupport.validateAndEvaluate((String)"Holt-Winters view", (StatementContext)context.getStatementContext(), viewParameters.subList(1, viewParameters.size()));
        this.alpha = this.toNumber("alpha", evaluated.get(0)).doubleValue();
        if (evaluated.size() > 1) {
            this.beta = this.toNumber("beta", evaluated.get(1)).doubleValue();
            if (evaluated.size() > 2) {
                this.gamma = this.toNumber("gamma", evaluated.get(2)).doubleValue();
                this.period = this.toNumber("period", evaluated.get(3)).intValue();
            }
        }
    }

    private Number toNumber(String name, Object evaluated) throws ViewParameterException {
        if (!(evaluated instanceof Number)) {
            throw new ViewParameterException("Parameter " + name + " is not a number");
        }
        return (Number)evaluated;
    }

    public void attach(EventType parentEventType, StatementContext context, ViewFactory optionalParentViewFactory, List<ViewFactory> parentViewFactories) throws ViewParameterException {
        ExprNode[] validated = ViewFactorySupport.validate((String)"Holt-Winters view", (EventType)parentEventType, (StatementContext)context, Arrays.asList(this.fieldName), (boolean)false);
        if (!JavaClassHelper.isNumeric((Class)validated[0].getExprEvaluator().getType())) {
            throw new ViewParameterException("The field expression for the Holt-Winters view must be of a numeric type");
        }
        this.fieldName = validated[0];
        this.eventType = HoltWinters.createEventType(context);
    }

    public boolean canProvideCapability(ViewCapability arg0) {
        return false;
    }

    public boolean canReuse(View view) {
        return false;
    }

    public EventType getEventType() {
        return this.eventType;
    }

    public View makeView(StatementContext context) {
        if (this.beta == Double.MIN_VALUE) {
            return new HoltWinters(this.eventType, context, this.fieldName, this.alpha);
        }
        if (this.gamma == Double.MIN_VALUE) {
            return new HoltWinters(this.eventType, context, this.fieldName, this.alpha, this.beta);
        }
        return new HoltWinters(this.eventType, context, this.fieldName, this.alpha, this.beta, this.gamma, this.period);
    }

    public void setProvideCapability(ViewCapability capability, ViewResourceCallback callback) {
        throw new UnsupportedOperationException();
    }
}

