/*
 * Decompiled with CFR 0.152.
 */
package com.ning.metrics.meteo.esper;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.collection.SingleEventIterator;
import com.espertech.esper.core.StatementContext;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.view.ViewSupport;
import com.ning.metrics.meteo.esper.HoltWintersComputer;
import com.ning.metrics.meteo.publishers.EsperListener;
import java.util.HashMap;
import java.util.Iterator;

public class HoltWinters
extends ViewSupport {
    private final EventType eventType;
    private final StatementContext context;
    private final ExprNode fieldNameX;
    private final EventBean[] eventsPerStream = new EventBean[1];
    private final HoltWintersComputer computer;
    private EventBean lastNewEvent;
    private double lastRaw;
    private static final double ALPHA = 0.5;
    private HoltWintersComputer deviationComputer;
    private long currentEventTimeStamp;

    public HoltWinters(EventType eventType, StatementContext context, ExprNode fieldNameX, double alpha) {
        this.eventType = eventType;
        this.context = context;
        this.fieldNameX = fieldNameX;
        this.computer = new HoltWintersComputer(alpha);
        this.deviationComputer = new HoltWintersComputer(0.5);
    }

    public HoltWinters(EventType eventType, StatementContext context, ExprNode fieldNameX, double alpha, double beta) {
        this.eventType = eventType;
        this.context = context;
        this.fieldNameX = fieldNameX;
        this.computer = new HoltWintersComputer(alpha, beta);
        this.deviationComputer = new HoltWintersComputer(0.5);
    }

    public static EventType createEventType(StatementContext context) {
        HashMap<String, Class<Number>> schemaMap = new HashMap<String, Class<Number>>();
        schemaMap.put("timestamp", Long.TYPE);
        schemaMap.put("forecast", Double.TYPE);
        schemaMap.put("lastRaw", Double.TYPE);
        schemaMap.put("deviation", Double.TYPE);
        schemaMap.put("smoothedDeviation", Double.TYPE);
        return context.getEventAdapterService().createAnonymousMapType(schemaMap);
    }

    public HoltWinters(EventType eventType, StatementContext context, ExprNode fieldNameX, double alpha, double beta, double gamma, int period) {
        this.eventType = eventType;
        this.context = context;
        this.fieldNameX = fieldNameX;
        this.computer = new HoltWintersComputer(alpha, beta, gamma, period);
    }

    private void processSingleValue(double value) {
        this.computer.addNextValue(value);
        this.deviationComputer.addNextValue(this.computer.getDeviation());
    }

    public void update(EventBean[] newData, EventBean[] oldData) {
        EventBean oldDataEvent = this.getDataEvent();
        if (this.hasViews()) {
            EventBean newDataEvent = this.getDataEvent();
            if (this.lastNewEvent == null) {
                this.updateChildren(new EventBean[]{newDataEvent}, new EventBean[]{oldDataEvent});
            } else {
                this.updateChildren(new EventBean[]{newDataEvent}, new EventBean[]{this.lastNewEvent});
            }
            this.lastNewEvent = newDataEvent;
        }
        if (newData != null) {
            for (EventBean event : newData) {
                this.currentEventTimeStamp = EsperListener.getEventMillis(event, "timestamp");
                this.eventsPerStream[0] = event;
                Number number = (Number)this.fieldNameX.getExprEvaluator().evaluate(this.eventsPerStream, true, (ExprEvaluatorContext)this.context);
                if (number == null) continue;
                this.lastRaw = number.doubleValue();
                this.processSingleValue(this.lastRaw);
            }
        }
    }

    public EventType getEventType() {
        return this.eventType;
    }

    public Iterator<EventBean> iterator() {
        return new SingleEventIterator(this.getDataEvent());
    }

    private EventBean getDataEvent() {
        HashMap<String, Number> dataMap = new HashMap<String, Number>();
        dataMap.put("timestamp", this.currentEventTimeStamp);
        dataMap.put("forecast", this.computer.getForecast(1));
        dataMap.put("lastRaw", this.lastRaw);
        dataMap.put("deviation", this.computer.getDeviation());
        dataMap.put("smoothedDeviation", this.deviationComputer.getDeviation());
        return this.context.getEventAdapterService().adaptorForTypedMap(dataMap, this.eventType);
    }
}

