/*
 * Decompiled with CFR 0.152.
 */
package com.ning.metrics.meteo.binder;

import com.espertech.esper.client.Configuration;
import com.espertech.esper.client.EPServiceProvider;
import com.espertech.esper.client.EPServiceProviderManager;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.TypeLiteral;
import com.ning.metrics.meteo.binder.RealtimeSystemConfig;
import com.ning.metrics.meteo.binder.StatementsConfig;
import com.ning.metrics.meteo.binder.StreamConfig;
import com.ning.metrics.meteo.publishers.PublisherConfig;
import com.ning.metrics.meteo.publishers.PublishersCompiler;
import com.ning.metrics.meteo.subscribers.SubscriberConfig;
import com.ning.metrics.meteo.subscribers.SubscribersCompiler;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.List;
import javax.management.MBeanServer;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.jaxrs.JacksonJsonProvider;
import org.codehaus.jackson.map.ObjectMapper;
import org.skife.config.ConfigurationObjectFactory;

public class RealtimeSystemModule
implements Module {
    private static final ObjectMapper mapper = new ObjectMapper();

    public void configure(Binder binder) {
        binder.bind(MBeanServer.class).toInstance((Object)ManagementFactory.getPlatformMBeanServer());
        binder.bind(JacksonJsonProvider.class).asEagerSingleton();
        RealtimeSystemConfig config = (RealtimeSystemConfig)new ConfigurationObjectFactory(System.getProperties()).build(RealtimeSystemConfig.class);
        binder.bind(RealtimeSystemConfig.class).toInstance((Object)config);
        Configuration configuration = new Configuration();
        if (!config.getEsperConfigurationFile().equals("")) {
            configuration.configure(new File(config.getEsperConfigurationFile()));
        }
        binder.bind(EPServiceProvider.class).toInstance((Object)EPServiceProviderManager.getDefaultProvider((Configuration)configuration));
        this.configureFromFile(binder, config.getConfigurationFile());
    }

    private void configureFromFile(Binder binder, String statementConfig) {
        StatementsConfig statementsConfig;
        try {
            statementsConfig = (StatementsConfig)mapper.readValue(new File(statementConfig), StatementsConfig.class);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to parse the main configuration file", e);
        }
        binder.bind((TypeLiteral)new TypeLiteral<List<SubscriberConfig>>(){}).toInstance(statementsConfig.getSubscribers());
        binder.bind(SubscribersCompiler.class).asEagerSingleton();
        binder.bind((TypeLiteral)new TypeLiteral<List<PublisherConfig>>(){}).toInstance(statementsConfig.getPublishers());
        binder.bind((TypeLiteral)new TypeLiteral<List<StreamConfig>>(){}).toInstance(statementsConfig.getStatements());
        binder.bind(PublishersCompiler.class).asEagerSingleton();
    }

    static {
        mapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
    }
}

