/*
 * Decompiled with CFR 0.152.
 */
package com.ning.metrics.meteo;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.servlet.ServletModule;
import com.ning.metrics.meteo.binder.RealtimeSystemModule;
import com.ning.metrics.meteo.server.JettyServer;
import com.ning.metrics.meteo.subscribers.SubscribersCompiler;
import com.sun.jersey.guice.spi.container.servlet.GuiceContainer;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jetty.servlet.DefaultServlet;

public class RealtimeSystem {
    public static void main(String[] args) throws Exception {
        Injector injector = Guice.createInjector((Module[])new Module[]{new RealtimeSystemModule(), new ServletModule(){

            protected void configureServlets() {
                this.bind(DefaultServlet.class).asEagerSingleton();
                this.serve("/media/*", new String[0]).with(DefaultServlet.class);
                this.serve("*", new String[0]).with(GuiceContainer.class, (Map)new HashMap<String, String>(){
                    {
                        this.put("com.sun.jersey.config.property.packages", "com.ning.metrics.meteo.server.resources");
                    }
                });
            }
        }});
        final SubscribersCompiler subscribersCompiler = (SubscribersCompiler)injector.getInstance(SubscribersCompiler.class);
        subscribersCompiler.startAll();
        final JettyServer jetty = (JettyServer)injector.getInstance(JettyServer.class);
        jetty.start(injector);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                subscribersCompiler.stopAll();
                jetty.stop();
            }
        });
    }
}

