/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.providers.netty;

import com.ning.http.client.AsyncHttpProvider;
import com.ning.http.client.HttpResponseBodyPart;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicReference;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.handler.codec.http.HttpChunk;
import org.jboss.netty.handler.codec.http.HttpResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResponseBodyPart
extends HttpResponseBodyPart {
    private final HttpChunk chunk;
    private final HttpResponse response;
    private final AtomicReference<byte[]> bytes = new AtomicReference<Object>(null);

    public ResponseBodyPart(URI uri, HttpResponse response, AsyncHttpProvider<HttpResponse> provider) {
        super(uri, provider);
        this.chunk = null;
        this.response = response;
    }

    public ResponseBodyPart(URI uri, HttpResponse response, AsyncHttpProvider<HttpResponse> provider, HttpChunk chunk) {
        super(uri, provider);
        this.chunk = chunk;
        this.response = response;
    }

    @Override
    public byte[] getBodyPartBytes() {
        if (this.bytes.get() != null) {
            return this.bytes.get();
        }
        ChannelBuffer b = this.chunk != null ? this.chunk.getContent() : this.response.getContent();
        int read = b.readableBytes();
        int index = b.readerIndex();
        byte[] rb = new byte[read];
        b.readBytes(rb);
        this.bytes.set(rb);
        b.readerIndex(index);
        return this.bytes.get();
    }

    @Override
    public int writeTo(OutputStream outputStream) throws IOException {
        ChannelBuffer b = this.chunk != null ? this.chunk.getContent() : this.response.getContent();
        int read = b.readableBytes();
        int index = b.readerIndex();
        if (read > 0) {
            b.readBytes(outputStream, read);
        }
        b.readerIndex(index);
        return read;
    }

    @Override
    public ByteBuffer getBodyByteBuffer() {
        return ByteBuffer.wrap(this.getBodyPartBytes());
    }

    protected HttpChunk chunk() {
        return this.chunk;
    }
}

