/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.util;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.X509Certificate;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class SslUtils {
    public static SSLEngine getSSLEngine() throws GeneralSecurityException, IOException {
        SSLEngine engine = null;
        SSLContext context = SslUtils.getSSLContext();
        if (context != null) {
            engine = context.createSSLEngine();
            engine.setUseClientMode(true);
        }
        return engine;
    }

    public static SSLContext getSSLContext() throws GeneralSecurityException, IOException {
        SSLConfig config = new SSLConfig();
        if (config.keyStoreLocation == null || config.trustStoreLocation != null) {
            return SslUtils.getLooseSSLContext();
        }
        return SslUtils.getStrictSSLContext(config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static SSLContext getStrictSSLContext(SSLConfig config) throws GeneralSecurityException, IOException {
        KeyStore keyStore = KeyStore.getInstance(config.keyStoreType);
        FileInputStream keystoreInputStream = new FileInputStream(config.keyStoreLocation);
        try {
            keyStore.load(keystoreInputStream, config.keyStorePassword == null ? null : config.keyStorePassword.toCharArray());
        }
        finally {
            ((InputStream)keystoreInputStream).close();
        }
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(config.keyManagerAlgorithm);
        keyManagerFactory.init(keyStore, config.keyManagerPassword == null ? null : config.keyManagerPassword.toCharArray());
        KeyManager[] keyManagers = keyManagerFactory.getKeyManagers();
        KeyStore trustStore = KeyStore.getInstance(config.trustStoreType);
        FileInputStream truststoreInputStream = new FileInputStream(config.trustStoreLocation);
        try {
            trustStore.load(truststoreInputStream, config.trustStorePassword == null ? null : config.trustStorePassword.toCharArray());
        }
        finally {
            ((InputStream)truststoreInputStream).close();
        }
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(config.trustManagerAlgorithm);
        trustManagerFactory.init(trustStore);
        TrustManager[] trustManagers = trustManagerFactory.getTrustManagers();
        SSLContext context = SSLContext.getInstance("TLS");
        context.init(keyManagers, trustManagers, null);
        return context;
    }

    static SSLContext getLooseSSLContext() throws GeneralSecurityException {
        SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.init(null, new TrustManager[]{LooseTrustManager.INSTANCE}, new SecureRandom());
        return sslContext;
    }

    private static final class SSLConfig {
        public String keyStoreLocation = System.getProperty("javax.net.ssl.keyStore");
        public String keyStoreType = "JKS";
        public String keyStorePassword = System.getProperty("javax.net.ssl.keyStorePassword", "changeit");
        public String keyManagerAlgorithm = "SunX509";
        public String keyManagerPassword = "changeit";
        public String trustStoreLocation;
        public String trustStoreType = "JKS";
        public String trustStorePassword = "changeit";
        public String trustManagerAlgorithm = "SunX509";

        public SSLConfig() {
            this.keyStoreType = System.getProperty("javax.net.ssl.keyStoreType", KeyStore.getDefaultType());
            this.keyManagerAlgorithm = Security.getProperty("ssl.KeyManagerFactory.algorithm");
            if (this.keyManagerAlgorithm == null) {
                this.keyManagerAlgorithm = "SunX509";
            }
            this.keyManagerPassword = System.getProperty("javax.net.ssl.keyStorePassword", "changeit");
            this.trustStoreLocation = System.getProperty("javax.net.ssl.trustStore");
            if (this.trustStoreLocation == null) {
                this.trustStoreLocation = this.keyStoreLocation;
                this.trustStorePassword = this.keyStorePassword;
                this.trustStoreType = this.keyStoreType;
            } else {
                this.trustStorePassword = System.getProperty("javax.net.ssl.trustStorePassword", "changeit");
                this.trustStoreType = System.getProperty("javax.net.ssl.trustStoreType", KeyStore.getDefaultType());
            }
            this.trustManagerAlgorithm = Security.getProperty("ssl.TrustManagerFactory.algorithm");
            if (this.trustManagerAlgorithm == null) {
                this.trustManagerAlgorithm = "SunX509";
            }
        }
    }

    static class LooseTrustManager
    implements X509TrustManager {
        public static final LooseTrustManager INSTANCE = new LooseTrustManager();

        LooseTrustManager() {
        }

        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }

        public void checkClientTrusted(X509Certificate[] certs, String authType) {
        }

        public void checkServerTrusted(X509Certificate[] certs, String authType) {
        }
    }
}

