/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.webdav;

import com.ning.http.client.AsyncCompletionHandlerBase;
import com.ning.http.client.AsyncHandler;
import com.ning.http.client.HttpResponseBodyPart;
import com.ning.http.client.HttpResponseHeaders;
import com.ning.http.client.HttpResponseStatus;
import com.ning.http.client.Response;
import com.ning.http.client.logging.LogManager;
import com.ning.http.client.logging.Logger;
import com.ning.http.client.webdav.WebDavResponse;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class WebDavCompletionHandlerBase<T>
implements AsyncHandler<T> {
    private final Logger logger = LogManager.getLogger(AsyncCompletionHandlerBase.class);
    private final Collection<HttpResponseBodyPart> bodies = Collections.synchronizedCollection(new ArrayList());
    private HttpResponseStatus status;
    private HttpResponseHeaders headers;

    @Override
    public AsyncHandler.STATE onBodyPartReceived(HttpResponseBodyPart content) throws Exception {
        this.bodies.add(content);
        return AsyncHandler.STATE.CONTINUE;
    }

    @Override
    public final AsyncHandler.STATE onStatusReceived(HttpResponseStatus status) throws Exception {
        this.status = status;
        return AsyncHandler.STATE.CONTINUE;
    }

    @Override
    public final AsyncHandler.STATE onHeadersReceived(HttpResponseHeaders headers) throws Exception {
        this.headers = headers;
        return AsyncHandler.STATE.CONTINUE;
    }

    @Override
    public final T onCompleted() throws Exception {
        Response response = this.status.provider().prepareResponse(this.status, this.headers, this.bodies);
        Document document = null;
        if (this.status.getStatusCode() == 207) {
            document = this.readXMLResponse(response.getResponseBodyAsStream());
        }
        return this.onCompleted(this.status == null ? null : new WebDavResponse(this.status.provider().prepareResponse(this.status, this.headers, this.bodies), document));
    }

    @Override
    public void onThrowable(Throwable t) {
        this.logger.debug(t);
    }

    public abstract T onCompleted(WebDavResponse var1) throws Exception;

    private Document readXMLResponse(InputStream stream) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        Document document = null;
        try {
            document = factory.newDocumentBuilder().parse(stream);
            this.parse(document);
        }
        catch (SAXException e) {
            this.logger.error(e.getMessage(), e);
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            this.logger.error(e.getMessage(), e);
            throw new RuntimeException(e);
        }
        catch (ParserConfigurationException e) {
            this.logger.error(e.getMessage(), e);
            throw new RuntimeException(e);
        }
        return document;
    }

    private void parse(Document document) {
        Element element = document.getDocumentElement();
        NodeList statusNode = element.getElementsByTagName("status");
        for (int i = 0; i < statusNode.getLength(); ++i) {
            Node node = statusNode.item(i);
            String value = node.getFirstChild().getNodeValue();
            int statusCode = Integer.valueOf(value.substring(value.indexOf(" "), value.lastIndexOf(" ")).trim());
            String statusText = value.substring(value.lastIndexOf(" "));
            this.status = new HttpStatusWrapper(this.status, statusText, statusCode);
        }
    }

    private class HttpStatusWrapper
    extends HttpResponseStatus {
        private final HttpResponseStatus wrapper;
        private final String statusText;
        private final int statusCode;

        public HttpStatusWrapper(HttpResponseStatus wrapper, String statusText, int statusCode) {
            super(wrapper.getUrl(), wrapper.provider());
            this.wrapper = wrapper;
            this.statusText = statusText;
            this.statusCode = statusCode;
        }

        public int getStatusCode() {
            return this.statusText == null ? this.wrapper.getStatusCode() : this.statusCode;
        }

        public String getStatusText() {
            return this.statusText == null ? this.wrapper.getStatusText() : this.statusText;
        }

        public String getProtocolName() {
            return this.wrapper.getProtocolName();
        }

        public int getProtocolMajorVersion() {
            return this.wrapper.getProtocolMajorVersion();
        }

        public int getProtocolMinorVersion() {
            return this.wrapper.getProtocolMinorVersion();
        }

        public String getProtocolText() {
            return this.wrapper.getStatusText();
        }
    }
}

