/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.networknt.schema.BaseJsonValidator;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonType;
import com.networknt.schema.JsonValidator;
import com.networknt.schema.TypeFactory;
import com.networknt.schema.UnionTypeValidator;
import com.networknt.schema.ValidationMessage;
import com.networknt.schema.ValidatorTypeCode;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TypeValidator
extends BaseJsonValidator
implements JsonValidator {
    private static final Logger logger = LoggerFactory.getLogger(TypeValidator.class);
    private JsonType schemaType;
    private UnionTypeValidator unionTypeValidator;

    public TypeValidator(String schemaPath, JsonNode schemaNode, JsonSchema parentSchema, ObjectMapper mapper) {
        super(schemaPath, schemaNode, parentSchema, ValidatorTypeCode.TYPE);
        this.schemaType = TypeFactory.getSchemaNodeType(schemaNode);
        if (this.schemaType == JsonType.UNION) {
            this.unionTypeValidator = new UnionTypeValidator(schemaPath, schemaNode, parentSchema, mapper);
        }
        this.parseErrorCode(this.getValidatorType().getErrorCodeKey());
    }

    @Override
    public Set<ValidationMessage> validate(JsonNode node, JsonNode rootNode, String at) {
        this.debug(logger, node, rootNode, at);
        HashSet<ValidationMessage> errors = new HashSet<ValidationMessage>();
        if (this.schemaType == JsonType.UNION) {
            errors.addAll(this.unionTypeValidator.validate(node, rootNode, at));
            return errors;
        }
        JsonType nodeType = TypeFactory.getValueNodeType(node);
        if (nodeType != this.schemaType) {
            if (this.schemaType == JsonType.ANY) {
                return errors;
            }
            if (this.schemaType == JsonType.NUMBER && nodeType == JsonType.INTEGER) {
                return errors;
            }
            errors.add(this.buildValidationMessage(at, nodeType.toString(), this.schemaType.toString()));
        }
        return errors;
    }
}

