/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.networknt.schema.BaseJsonValidator;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonType;
import com.networknt.schema.JsonValidator;
import com.networknt.schema.TypeFactory;
import com.networknt.schema.ValidationMessage;
import com.networknt.schema.ValidatorTypeCode;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MaxLengthValidator
extends BaseJsonValidator
implements JsonValidator {
    private static final Logger logger = LoggerFactory.getLogger(MaxLengthValidator.class);
    private int maxLength = Integer.MAX_VALUE;

    public MaxLengthValidator(String schemaPath, JsonNode schemaNode, JsonSchema parentSchema, ObjectMapper mapper) {
        super(schemaPath, schemaNode, parentSchema, ValidatorTypeCode.MAX_LENGTH);
        if (schemaNode != null && schemaNode.isIntegralNumber()) {
            this.maxLength = schemaNode.intValue();
        }
        this.parseErrorCode(this.getValidatorType().getErrorCodeKey());
    }

    @Override
    public Set<ValidationMessage> validate(JsonNode node, JsonNode rootNode, String at) {
        this.debug(logger, node, rootNode, at);
        JsonType nodeType = TypeFactory.getValueNodeType(node);
        HashSet<ValidationMessage> errors = new HashSet<ValidationMessage>();
        if (nodeType != JsonType.STRING) {
            return errors;
        }
        if (node.textValue().codePointCount(0, node.textValue().length()) > this.maxLength) {
            errors.add(this.buildValidationMessage(at, "" + this.maxLength));
        }
        return errors;
    }
}

