/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.networknt.schema.BaseJsonValidator;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonValidator;
import com.networknt.schema.ValidationMessage;
import com.networknt.schema.ValidatorTypeCode;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AllOfValidator
extends BaseJsonValidator
implements JsonValidator {
    private static final Logger logger = LoggerFactory.getLogger(AllOfValidator.class);
    private List<JsonSchema> schemas = new ArrayList<JsonSchema>();

    public AllOfValidator(String schemaPath, JsonNode schemaNode, JsonSchema parentSchema, ObjectMapper mapper) {
        super(schemaPath, schemaNode, parentSchema, ValidatorTypeCode.ALL_OF);
        int size = schemaNode.size();
        for (int i = 0; i < size; ++i) {
            this.schemas.add(new JsonSchema(mapper, this.getValidatorType().getValue(), schemaNode.get(i), parentSchema));
        }
    }

    @Override
    public Set<ValidationMessage> validate(JsonNode node, JsonNode rootNode, String at) {
        this.debug(logger, node, rootNode, at);
        int size = this.schemas.size();
        HashSet<ValidationMessage> errors = new HashSet<ValidationMessage>();
        for (int i = 0; i < size; ++i) {
            errors.addAll(this.schemas.get(i).validate(node, rootNode, at));
        }
        return errors;
    }
}

