/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zuul;

import com.netflix.servo.monitor.DynamicCounter;
import com.netflix.zuul.ExecutionStatus;
import com.netflix.zuul.FilterLoader;
import com.netflix.zuul.FilterUsageNotifier;
import com.netflix.zuul.ZuulFilter;
import com.netflix.zuul.ZuulFilterResult;
import com.netflix.zuul.context.Debug;
import com.netflix.zuul.context.RequestContext;
import com.netflix.zuul.exception.ZuulException;
import com.netflix.zuul.monitoring.MonitoringHelper;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilterProcessor {
    static FilterProcessor INSTANCE = new FilterProcessor();
    protected static final Logger logger = LoggerFactory.getLogger(FilterProcessor.class);
    private FilterUsageNotifier usageNotifier = new BasicFilterUsageNotifier();

    public static FilterProcessor getInstance() {
        return INSTANCE;
    }

    public static void setProcessor(FilterProcessor processor) {
        INSTANCE = processor;
    }

    public void setFilterUsageNotifier(FilterUsageNotifier notifier) {
        this.usageNotifier = notifier;
    }

    public void postRoute() throws ZuulException {
        try {
            this.runFilters("post");
        }
        catch (Throwable e) {
            if (e instanceof ZuulException) {
                throw (ZuulException)e;
            }
            throw new ZuulException(e, 500, "UNCAUGHT_EXCEPTION_IN_POST_FILTER_" + e.getClass().getName());
        }
    }

    public void error() {
        try {
            this.runFilters("error");
        }
        catch (Throwable e) {
            logger.error(e.getMessage(), e);
        }
    }

    public void route() throws ZuulException {
        try {
            this.runFilters("route");
        }
        catch (Throwable e) {
            if (e instanceof ZuulException) {
                throw (ZuulException)e;
            }
            throw new ZuulException(e, 500, "UNCAUGHT_EXCEPTION_IN_ROUTE_FILTER_" + e.getClass().getName());
        }
    }

    public void preRoute() throws ZuulException {
        try {
            this.runFilters("pre");
        }
        catch (Throwable e) {
            if (e instanceof ZuulException) {
                throw (ZuulException)e;
            }
            throw new ZuulException(e, 500, "UNCAUGHT_EXCEPTION_IN_PRE_FILTER_" + e.getClass().getName());
        }
    }

    public Object runFilters(String sType) throws Throwable {
        if (RequestContext.getCurrentContext().debugRouting()) {
            Debug.addRoutingDebug("Invoking {" + sType + "} type filters");
        }
        boolean bResult = false;
        List<ZuulFilter> list = FilterLoader.getInstance().getFiltersByType(sType);
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                ZuulFilter zuulFilter = list.get(i);
                Object result = this.processZuulFilter(zuulFilter);
                if (result == null || !(result instanceof Boolean)) continue;
                bResult |= ((Boolean)result).booleanValue();
            }
        }
        return bResult;
    }

    public Object processZuulFilter(ZuulFilter filter) throws ZuulException {
        RequestContext ctx = RequestContext.getCurrentContext();
        boolean bDebug = ctx.debugRouting();
        String metricPrefix = "zuul.filter-";
        long execTime = 0L;
        String filterName = "";
        try {
            long ltime = System.currentTimeMillis();
            filterName = filter.getClass().getSimpleName();
            RequestContext copy = null;
            Object o = null;
            Throwable t = null;
            if (bDebug) {
                Debug.addRoutingDebug("Filter " + filter.filterType() + " " + filter.filterOrder() + " " + filterName);
                copy = ctx.copy();
            }
            ZuulFilterResult result = filter.runFilter();
            ExecutionStatus s = result.getStatus();
            execTime = System.currentTimeMillis() - ltime;
            switch (s) {
                case FAILED: {
                    t = result.getException();
                    ctx.addFilterExecutionSummary(filterName, ExecutionStatus.FAILED.name(), execTime);
                    break;
                }
                case SUCCESS: {
                    o = result.getResult();
                    ctx.addFilterExecutionSummary(filterName, ExecutionStatus.SUCCESS.name(), execTime);
                    if (!bDebug) break;
                    Debug.addRoutingDebug("Filter {" + filterName + " TYPE:" + filter.filterType() + " ORDER:" + filter.filterOrder() + "} Execution time = " + execTime + "ms");
                    Debug.compareContextState(filterName, copy);
                    break;
                }
            }
            if (t != null) {
                throw t;
            }
            this.usageNotifier.notify(filter, s);
            return o;
        }
        catch (Throwable e) {
            if (bDebug) {
                Debug.addRoutingDebug("Running Filter failed " + filterName + " type:" + filter.filterType() + " order:" + filter.filterOrder() + " " + e.getMessage());
            }
            this.usageNotifier.notify(filter, ExecutionStatus.FAILED);
            if (e instanceof ZuulException) {
                throw (ZuulException)e;
            }
            ZuulException ex = new ZuulException(e, "Filter threw Exception", 500, filter.filterType() + ":" + filterName);
            ctx.addFilterExecutionSummary(filterName, ExecutionStatus.FAILED.name(), execTime);
            throw ex;
        }
    }

    @RunWith(value=MockitoJUnitRunner.class)
    public static class UnitTest {
        @Mock
        ZuulFilter filter;

        @Before
        public void before() {
            MonitoringHelper.initMocks();
            MockitoAnnotations.initMocks((Object)this);
        }

        @Test
        public void testProcessZuulFilter() {
            FilterProcessor processor = new FilterProcessor();
            processor = (FilterProcessor)Mockito.spy((Object)processor);
            try {
                processor.processZuulFilter(this.filter);
                ((FilterProcessor)Mockito.verify((Object)processor, (VerificationMode)Mockito.times((int)1))).processZuulFilter(this.filter);
                ((ZuulFilter)Mockito.verify((Object)this.filter, (VerificationMode)Mockito.times((int)1))).runFilter();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }

        @Test
        public void testProcessZuulFilterException() {
            FilterProcessor processor = new FilterProcessor();
            processor = (FilterProcessor)Mockito.spy((Object)processor);
            try {
                ZuulFilterResult r = new ZuulFilterResult(ExecutionStatus.FAILED);
                r.setException(new Exception("Test"));
                Mockito.when((Object)this.filter.runFilter()).thenReturn((Object)r);
                Mockito.when((Object)this.filter.filterType()).thenReturn((Object)"post");
                processor.processZuulFilter(this.filter);
                Assert.assertFalse((boolean)true);
            }
            catch (Throwable e) {
                Assert.assertEquals((Object)e.getCause().getMessage(), (Object)"Test");
            }
        }

        @Test
        public void testPostProcess() {
            FilterProcessor processor = new FilterProcessor();
            processor = (FilterProcessor)Mockito.spy((Object)processor);
            try {
                processor.postRoute();
                ((FilterProcessor)Mockito.verify((Object)processor, (VerificationMode)Mockito.times((int)1))).runFilters("post");
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }

        @Test
        public void testPreProcess() {
            FilterProcessor processor = new FilterProcessor();
            processor = (FilterProcessor)Mockito.spy((Object)processor);
            try {
                processor.preRoute();
                ((FilterProcessor)Mockito.verify((Object)processor, (VerificationMode)Mockito.times((int)1))).runFilters("pre");
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }

        @Test
        public void testRouteProcess() {
            FilterProcessor processor = new FilterProcessor();
            processor = (FilterProcessor)Mockito.spy((Object)processor);
            try {
                processor.route();
                ((FilterProcessor)Mockito.verify((Object)processor, (VerificationMode)Mockito.times((int)1))).runFilters("route");
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }

        @Test
        public void testRouteProcessHttpException() {
            HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
            HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
            RequestContext.getCurrentContext().setRequest(request);
            RequestContext.getCurrentContext().setResponse(response);
            FilterProcessor processor = new FilterProcessor();
            processor = (FilterProcessor)Mockito.spy((Object)processor);
            try {
                Mockito.when((Object)processor.runFilters("route")).thenThrow(new Throwable[]{new ZuulException("test", 400, "test")});
                Mockito.when((Object)this.filter.filterType()).thenReturn((Object)"post");
                processor.route();
            }
            catch (ZuulException e) {
                Assert.assertEquals((Object)e.getMessage(), (Object)"test");
                Assert.assertEquals((long)e.nStatusCode, (long)400L);
            }
            catch (Throwable e) {
                e.printStackTrace();
                Assert.assertFalse((boolean)true);
            }
        }

        @Test
        public void testRouteProcessException() {
            HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
            HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
            RequestContext.getCurrentContext().setRequest(request);
            RequestContext.getCurrentContext().setResponse(response);
            FilterProcessor processor = new FilterProcessor();
            processor = (FilterProcessor)Mockito.spy((Object)processor);
            try {
                Mockito.when((Object)processor.runFilters("route")).thenThrow(new Throwable[]{new Throwable("test")});
                Mockito.when((Object)this.filter.filterType()).thenReturn((Object)"post");
                processor.route();
            }
            catch (ZuulException e) {
                Assert.assertEquals((Object)e.getMessage(), (Object)"test");
                Assert.assertEquals((long)e.nStatusCode, (long)500L);
            }
            catch (Throwable e) {
                Assert.assertFalse((boolean)true);
            }
        }

        @Test
        public void testPreProcessException() {
            HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
            HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
            RequestContext.getCurrentContext().setRequest(request);
            RequestContext.getCurrentContext().setResponse(response);
            FilterProcessor processor = new FilterProcessor();
            processor = (FilterProcessor)Mockito.spy((Object)processor);
            try {
                Mockito.when((Object)processor.runFilters("pre")).thenThrow(new Throwable[]{new Throwable("test")});
                Mockito.when((Object)this.filter.filterType()).thenReturn((Object)"post");
                processor.preRoute();
            }
            catch (ZuulException e) {
                Assert.assertEquals((Object)e.getMessage(), (Object)"test");
                Assert.assertEquals((long)e.nStatusCode, (long)500L);
            }
            catch (Throwable e) {
                Assert.assertFalse((boolean)true);
            }
        }

        @Test
        public void testPreProcessHttpException() {
            HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
            HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
            RequestContext.getCurrentContext().setRequest(request);
            RequestContext.getCurrentContext().setResponse(response);
            FilterProcessor processor = new FilterProcessor();
            processor = (FilterProcessor)Mockito.spy((Object)processor);
            try {
                Mockito.when((Object)processor.runFilters("pre")).thenThrow(new Throwable[]{new ZuulException("test", 400, "test")});
                Mockito.when((Object)this.filter.filterType()).thenReturn((Object)"post");
                processor.preRoute();
            }
            catch (ZuulException e) {
                Assert.assertEquals((Object)e.getMessage(), (Object)"test");
                Assert.assertEquals((long)e.nStatusCode, (long)400L);
            }
            catch (Throwable e) {
                e.printStackTrace();
                Assert.assertFalse((boolean)true);
            }
        }

        @Test
        public void testPostProcessException() {
            HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
            HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
            RequestContext.getCurrentContext().setRequest(request);
            RequestContext.getCurrentContext().setResponse(response);
            FilterProcessor processor = new FilterProcessor();
            processor = (FilterProcessor)Mockito.spy((Object)processor);
            try {
                Mockito.when((Object)processor.runFilters("post")).thenThrow(new Throwable[]{new Throwable("test")});
                Mockito.when((Object)this.filter.filterType()).thenReturn((Object)"post");
                processor.postRoute();
            }
            catch (ZuulException e) {
                Assert.assertEquals((Object)e.getMessage(), (Object)"test");
                Assert.assertEquals((long)e.nStatusCode, (long)500L);
            }
            catch (Throwable e) {
                Assert.assertFalse((boolean)true);
            }
        }

        @Test
        public void testPostProcessHttpException() {
            HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
            HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
            RequestContext.getCurrentContext().setRequest(request);
            RequestContext.getCurrentContext().setResponse(response);
            FilterProcessor processor = new FilterProcessor();
            processor = (FilterProcessor)Mockito.spy((Object)processor);
            try {
                Mockito.when((Object)processor.runFilters("post")).thenThrow(new Throwable[]{new ZuulException("test", 400, "test")});
                Mockito.when((Object)this.filter.filterType()).thenReturn((Object)"post");
                processor.postRoute();
            }
            catch (ZuulException e) {
                Assert.assertEquals((Object)e.getMessage(), (Object)"test");
                Assert.assertEquals((long)e.nStatusCode, (long)400L);
            }
            catch (Throwable e) {
                e.printStackTrace();
                Assert.assertFalse((boolean)true);
            }
        }

        @Test
        public void testErrorException() {
            FilterProcessor processor = new FilterProcessor();
            processor = (FilterProcessor)Mockito.spy((Object)processor);
            try {
                Mockito.when((Object)processor.runFilters("error")).thenThrow(new Throwable[]{new Exception("test")});
                Mockito.when((Object)this.filter.filterType()).thenReturn((Object)"post");
                processor.error();
                Assert.assertTrue((boolean)true);
            }
            catch (Throwable e) {
                Assert.assertFalse((boolean)true);
            }
        }

        @Test
        public void testErrorHttpException() {
            HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
            HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
            RequestContext.getCurrentContext().setRequest(request);
            RequestContext.getCurrentContext().setResponse(response);
            FilterProcessor processor = new FilterProcessor();
            processor = (FilterProcessor)Mockito.spy((Object)processor);
            try {
                Mockito.when((Object)processor.runFilters("error")).thenThrow(new Throwable[]{new ZuulException("test", 400, "test")});
                Mockito.when((Object)this.filter.filterType()).thenReturn((Object)"post");
                processor.error();
                Assert.assertTrue((boolean)true);
            }
            catch (Throwable e) {
                e.printStackTrace();
                Assert.assertFalse((boolean)true);
            }
        }
    }

    public static class BasicFilterUsageNotifier
    implements FilterUsageNotifier {
        private static final String METRIC_PREFIX = "zuul.filter-";

        @Override
        public void notify(ZuulFilter filter, ExecutionStatus status) {
            DynamicCounter.increment((String)(METRIC_PREFIX + filter.getClass().getSimpleName()), (String[])new String[]{"status", status.name(), "filtertype", filter.filterType()});
        }
    }
}

