/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.servo.monitor;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.netflix.servo.monitor.BasicTimer;
import com.netflix.servo.monitor.CompositeMonitor;
import com.netflix.servo.monitor.Monitor;
import com.netflix.servo.monitor.MonitorConfig;
import com.netflix.servo.monitor.Stopwatch;
import com.netflix.servo.monitor.Timer;
import com.netflix.servo.tag.BasicTagList;
import com.netflix.servo.tag.TagList;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.List;
import java.util.concurrent.ConcurrentMap;

public final class TimedInterface {
    static final String TIMED_INTERFACE = "TimedInterface";
    static final String INTERFACE_TAG = "interface";
    static final String CLASS_TAG = "class";
    static final String ID_TAG = "id";

    private TimedInterface() {
    }

    public static <T> T newProxy(Class<T> ctype, T concrete, String id) {
        TimedHandler<T> handler = new TimedHandler<T>(ctype, concrete, id);
        Class[] types = new Class[]{ctype, CompositeMonitor.class};
        return (T)Proxy.newProxyInstance(ctype.getClassLoader(), types, handler);
    }

    public static <T> T newProxy(Class<T> ctype, T concrete) {
        return TimedInterface.newProxy(ctype, concrete, null);
    }

    private static class TimedHandler<T>
    implements InvocationHandler,
    CompositeMonitor<Long> {
        final T concrete;
        final LoadingCache<String, Timer> timers;
        final MonitorConfig baseConfig;
        final TagList baseTagList;

        @Override
        public List<Monitor<?>> getMonitors() {
            ConcurrentMap timersMap = this.timers.asMap();
            return ImmutableList.copyOf(timersMap.values());
        }

        @Override
        public Long getValue() {
            return this.timers.asMap().size();
        }

        @Override
        public MonitorConfig getConfig() {
            return this.baseConfig;
        }

        TimedHandler(Class<T> ctype, T concrete, String id) {
            this.concrete = concrete;
            BasicTagList tagList = BasicTagList.of(TimedInterface.INTERFACE_TAG, ctype.getSimpleName(), TimedInterface.CLASS_TAG, concrete.getClass().getSimpleName());
            if (id != null) {
                tagList = tagList.copy(TimedInterface.ID_TAG, id);
            }
            this.baseTagList = tagList;
            this.baseConfig = MonitorConfig.builder(TimedInterface.TIMED_INTERFACE).withTags(this.baseTagList).build();
            this.timers = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, Timer>(){

                public Timer load(String method) throws Exception {
                    MonitorConfig config = MonitorConfig.builder(method).withTags(TimedHandler.this.baseTagList).build();
                    return new BasicTimer(config);
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Class<CompositeMonitor> declaringClass = method.getDeclaringClass();
            if (declaringClass.isAssignableFrom(CompositeMonitor.class)) {
                return method.invoke((Object)this, new Object[0]);
            }
            String methodName = method.getName();
            Timer timer = (Timer)this.timers.get((Object)methodName);
            Stopwatch stopwatch = timer.start();
            try {
                Object object = method.invoke(this.concrete, args);
                return object;
            }
            finally {
                stopwatch.stop();
            }
        }
    }
}

