/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.servo.monitor;

import com.google.common.base.Objects;
import com.netflix.servo.annotations.DataSourceType;
import com.netflix.servo.monitor.AbstractMonitor;
import com.netflix.servo.monitor.Gauge;
import com.netflix.servo.monitor.MonitorConfig;
import com.netflix.servo.monitor.ResettableMonitor;
import java.util.concurrent.atomic.AtomicLong;

public class MaxGauge
extends AbstractMonitor<Long>
implements Gauge<Long>,
ResettableMonitor<Long> {
    private final AtomicLong max = new AtomicLong(0L);

    public MaxGauge(MonitorConfig config) {
        super(config.withAdditionalTag(DataSourceType.GAUGE));
    }

    public void update(long v) {
        if (v > this.max.get()) {
            this.max.set(v);
        }
    }

    @Override
    public Long getValue() {
        return this.max.get();
    }

    @Override
    public Long getAndResetValue() {
        return this.max.getAndSet(0L);
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof MaxGauge)) {
            return false;
        }
        MaxGauge m = (MaxGauge)obj;
        return this.config.equals(m.getConfig()) && this.max.get() == m.max.get();
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.config, this.max.get()});
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("config", (Object)this.config).add("max", this.max.get()).toString();
    }
}

