/*
 * Decompiled with CFR 0.152.
 */
package feign;

import feign.Request;
import feign.Response;
import feign.RetryableException;
import feign.Util;
import java.io.IOException;

public class FeignException
extends RuntimeException {
    private static final long serialVersionUID = 0L;

    protected FeignException(String message, Throwable cause) {
        super(message, cause);
    }

    protected FeignException(String message) {
        super(message);
    }

    static FeignException errorReading(Request request, Response ignored, IOException cause) {
        return new FeignException(String.format("%s reading %s %s", cause.getMessage(), request.method(), request.url()), cause);
    }

    public static FeignException errorStatus(String methodKey, Response response) {
        String message = String.format("status %s reading %s", response.status(), methodKey);
        try {
            if (response.body() != null) {
                String body = Util.toString(response.body().asReader());
                message = message + "; content:\n" + body;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return new FeignException(message);
    }

    static FeignException errorExecuting(Request request, IOException cause) {
        return new RetryableException(String.format("%s executing %s %s", cause.getMessage(), request.method(), request.url()), cause, null);
    }
}

