/*
 * Decompiled with CFR 0.152.
 */
package feign;

import feign.Body;
import feign.Feign;
import feign.Headers;
import feign.MethodMetadata;
import feign.Param;
import feign.RequestLine;
import feign.Types;
import feign.Util;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public interface Contract {
    public List<MethodMetadata> parseAndValidatateMetadata(Class<?> var1);

    public static class Default
    extends BaseContract {
        @Override
        protected MethodMetadata parseAndValidateMetadata(Class<?> targetType, Method method) {
            MethodMetadata data = super.parseAndValidateMetadata(targetType, method);
            this.headersFromAnnotation(method.getDeclaringClass(), data);
            if (method.getDeclaringClass() != targetType) {
                this.headersFromAnnotation(targetType, data);
            }
            return data;
        }

        private void headersFromAnnotation(Class<?> targetType, MethodMetadata data) {
            if (targetType.isAnnotationPresent(Headers.class)) {
                String[] headersOnType = targetType.getAnnotation(Headers.class).value();
                Util.checkState(headersOnType.length > 0, "Headers annotation was empty on type %s.", targetType.getName());
                Map<String, Collection<String>> headers = Default.toMap(headersOnType);
                headers.putAll(data.template().headers());
                data.template().headers(null);
                data.template().headers(headers);
            }
        }

        @Override
        protected void processAnnotationOnMethod(MethodMetadata data, Annotation methodAnnotation, Method method) {
            Class<? extends Annotation> annotationType = methodAnnotation.annotationType();
            if (annotationType == RequestLine.class) {
                String requestLine = ((RequestLine)RequestLine.class.cast(methodAnnotation)).value();
                Util.checkState(Util.emptyToNull(requestLine) != null, "RequestLine annotation was empty on method %s.", method.getName());
                if (requestLine.indexOf(32) == -1) {
                    data.template().method(requestLine);
                    return;
                }
                data.template().method(requestLine.substring(0, requestLine.indexOf(32)));
                if (requestLine.indexOf(32) == requestLine.lastIndexOf(32)) {
                    data.template().append(requestLine.substring(requestLine.indexOf(32) + 1));
                } else {
                    data.template().append(requestLine.substring(requestLine.indexOf(32) + 1, requestLine.lastIndexOf(32)));
                }
                data.template().decodeSlash(((RequestLine)RequestLine.class.cast(methodAnnotation)).decodeSlash());
            } else if (annotationType == Body.class) {
                String body = ((Body)Body.class.cast(methodAnnotation)).value();
                Util.checkState(Util.emptyToNull(body) != null, "Body annotation was empty on method %s.", method.getName());
                if (body.indexOf(123) == -1) {
                    data.template().body(body);
                } else {
                    data.template().bodyTemplate(body);
                }
            } else if (annotationType == Headers.class) {
                String[] headersOnMethod = ((Headers)Headers.class.cast(methodAnnotation)).value();
                Util.checkState(headersOnMethod.length > 0, "Headers annotation was empty on method %s.", method.getName());
                data.template().headers(Default.toMap(headersOnMethod));
            }
        }

        @Override
        protected boolean processAnnotationsOnParameter(MethodMetadata data, Annotation[] annotations, int paramIndex) {
            boolean isHttpAnnotation = false;
            for (Annotation annotation : annotations) {
                Class<? extends Param.Expander> expander;
                Class<? extends Annotation> annotationType = annotation.annotationType();
                if (annotationType != Param.class) continue;
                String name = ((Param)annotation).value();
                Util.checkState(Util.emptyToNull(name) != null, "Param annotation was empty on param %s.", paramIndex);
                this.nameParam(data, name, paramIndex);
                if (annotationType == Param.class && (expander = ((Param)annotation).expander()) != Param.ToStringExpander.class) {
                    data.indexToExpanderClass().put(paramIndex, expander);
                }
                isHttpAnnotation = true;
                String varName = '{' + name + '}';
                if (data.template().url().indexOf(varName) != -1 || Default.searchMapValues(data.template().queries(), varName) || Default.searchMapValues(data.template().headers(), varName)) continue;
                data.formParams().add(name);
            }
            return isHttpAnnotation;
        }

        private static <K, V> boolean searchMapValues(Map<K, Collection<V>> map, V search) {
            Collection<Collection<V>> values = map.values();
            if (values == null) {
                return false;
            }
            for (Collection<V> entry : values) {
                if (!entry.contains(search)) continue;
                return true;
            }
            return false;
        }

        private static Map<String, Collection<String>> toMap(String[] input) {
            LinkedHashMap<String, Collection<String>> result = new LinkedHashMap<String, Collection<String>>(input.length);
            for (String header : input) {
                int colon = header.indexOf(58);
                String name = header.substring(0, colon);
                if (!result.containsKey(name)) {
                    result.put(name, new ArrayList(1));
                }
                ((Collection)result.get(name)).add(header.substring(colon + 2));
            }
            return result;
        }
    }

    public static abstract class BaseContract
    implements Contract {
        @Override
        public List<MethodMetadata> parseAndValidatateMetadata(Class<?> targetType) {
            Util.checkState(targetType.getTypeParameters().length == 0, "Parameterized types unsupported: %s", targetType.getSimpleName());
            Util.checkState(targetType.getInterfaces().length <= 1, "Only single inheritance supported: %s", targetType.getSimpleName());
            if (targetType.getInterfaces().length == 1) {
                Util.checkState(targetType.getInterfaces()[0].getInterfaces().length == 0, "Only single-level inheritance supported: %s", targetType.getSimpleName());
            }
            LinkedHashMap<String, MethodMetadata> result = new LinkedHashMap<String, MethodMetadata>();
            for (Method method : targetType.getMethods()) {
                if (method.getDeclaringClass() == Object.class) continue;
                MethodMetadata metadata = this.parseAndValidateMetadata(targetType, method);
                Util.checkState(!result.containsKey(metadata.configKey()), "Overrides unsupported: %s", metadata.configKey());
                result.put(metadata.configKey(), metadata);
            }
            return new ArrayList<MethodMetadata>(result.values());
        }

        @Deprecated
        public MethodMetadata parseAndValidatateMetadata(Method method) {
            return this.parseAndValidateMetadata(method.getDeclaringClass(), method);
        }

        protected MethodMetadata parseAndValidateMetadata(Class<?> targetType, Method method) {
            MethodMetadata data = new MethodMetadata();
            data.returnType(Types.resolve(targetType, targetType, method.getGenericReturnType()));
            data.configKey(Feign.configKey(targetType, method));
            for (Annotation methodAnnotation : method.getAnnotations()) {
                this.processAnnotationOnMethod(data, methodAnnotation, method);
            }
            Util.checkState(data.template().method() != null, "Method %s not annotated with HTTP method type (ex. GET, POST)", method.getName());
            Class<?>[] parameterTypes = method.getParameterTypes();
            Annotation[][] parameterAnnotations = method.getParameterAnnotations();
            int count = parameterAnnotations.length;
            for (int i = 0; i < count; ++i) {
                boolean isHttpAnnotation = false;
                if (parameterAnnotations[i] != null) {
                    isHttpAnnotation = this.processAnnotationsOnParameter(data, parameterAnnotations[i], i);
                }
                if (parameterTypes[i] == URI.class) {
                    data.urlIndex(i);
                    continue;
                }
                if (isHttpAnnotation) continue;
                Util.checkState(data.formParams().isEmpty(), "Body parameters cannot be used with form parameters.", new Object[0]);
                Util.checkState(data.bodyIndex() == null, "Method has too many Body parameters: %s", method);
                data.bodyIndex(i);
                data.bodyType(Types.resolve(targetType, targetType, method.getGenericParameterTypes()[i]));
            }
            return data;
        }

        protected abstract void processAnnotationOnMethod(MethodMetadata var1, Annotation var2, Method var3);

        protected abstract boolean processAnnotationsOnParameter(MethodMetadata var1, Annotation[] var2, int var3);

        protected Collection<String> addTemplatedParam(Collection<String> possiblyNull, String name) {
            if (possiblyNull == null) {
                possiblyNull = new ArrayList<String>();
            }
            possiblyNull.add(String.format("{%s}", name));
            return possiblyNull;
        }

        protected void nameParam(MethodMetadata data, String name, int i) {
            ArrayList<String> names = data.indexToName().containsKey(i) ? data.indexToName().get(i) : new ArrayList<String>();
            names.add(name);
            data.indexToName().put(i, names);
        }
    }
}

