/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.blitz4j;

import com.netflix.blitz4j.LoggingConfiguration;
import java.util.AbstractQueue;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.commons.collections.iterators.IteratorEnumeration;
import org.apache.log4j.Appender;
import org.apache.log4j.helpers.AppenderAttachableImpl;
import org.apache.log4j.spi.AppenderAttachable;
import org.apache.log4j.spi.LoggingEvent;

public class NFAppenderAttachableImpl
extends AppenderAttachableImpl
implements AppenderAttachable {
    protected AbstractQueue<Appender> appenderList = new ConcurrentLinkedQueue<Appender>();
    private AbstractQueue<String> configuredAppenderList = new ConcurrentLinkedQueue<String>();

    public void addAppender(Appender newAppender) {
        String appenderName;
        if (newAppender == null) {
            return;
        }
        boolean isAppenderPresent = this.appenderList.contains(newAppender);
        String string = appenderName = newAppender.getName() != null ? newAppender.getName() : "default";
        if (isAppenderPresent) {
            this.appenderList.add(newAppender);
            Iterator it = this.appenderList.iterator();
            while (it.hasNext()) {
                Appender appender = (Appender)it.next();
                if (!newAppender.equals(appender)) continue;
                this.configuredAppenderList.add(appenderName);
                it.remove();
                appender.close();
                return;
            }
        } else {
            this.appenderList.add(newAppender);
        }
        this.configuredAppenderList.add(appenderName);
    }

    public int appendLoopOnAppenders(LoggingEvent event) {
        int size = 0;
        if (this.appenderList != null) {
            size = this.appenderList.size();
            for (Appender appender : this.appenderList) {
                appender.doAppend(event);
            }
        }
        return size;
    }

    public Enumeration getAllAppenders() {
        if (this.appenderList == null) {
            return null;
        }
        Iterator it = this.appenderList.iterator();
        return new IteratorEnumeration(it);
    }

    public Appender getAppender(String name) {
        if (this.appenderList == null || name == null) {
            return null;
        }
        for (Appender appender : this.appenderList) {
            if (!name.equals(appender.getName())) continue;
            return appender;
        }
        return null;
    }

    public boolean isAttached(Appender appender) {
        if (this.appenderList == null || appender == null) {
            return false;
        }
        for (Appender a : this.appenderList) {
            if (a != appender) continue;
            return true;
        }
        return false;
    }

    public void removeAllAppenders() {
        this.configuredAppenderList.clear();
        if (this.appenderList != null) {
            Iterator it = this.appenderList.iterator();
            while (it.hasNext()) {
                String[] asyncAppenders;
                Appender a = (Appender)it.next();
                for (String asyncAppender : asyncAppenders = LoggingConfiguration.getInstance().getConfiguration().getAsyncAppenderImplementationNames()) {
                    if (asyncAppender.equals(a.getClass().getName())) continue;
                    it.remove();
                    a.close();
                }
            }
        }
    }

    public void removeAppender(Appender appender) {
        if (appender == null || this.appenderList == null) {
            return;
        }
        this.appenderList.remove(appender);
        this.configuredAppenderList.remove(appender.getName());
    }

    public void removeAppender(String name) {
        if (name == null || this.appenderList == null) {
            return;
        }
        Iterator it = this.appenderList.iterator();
        while (it.hasNext()) {
            Appender a = (Appender)it.next();
            if (!name.equals(a.getName())) continue;
            it.remove();
            this.configuredAppenderList.remove(a.getName());
            break;
        }
    }

    public void reconcileAppenders() {
        for (Appender appender : this.appenderList) {
            if (this.configuredAppenderList.contains(appender.getName())) continue;
            appender.close();
            this.appenderList.remove(appender);
        }
    }
}

