/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.blitz4j;

import com.netflix.blitz4j.BlitzConfig;
import com.netflix.config.DynamicPropertyFactory;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;

public class DefaultBlitz4jConfig
implements BlitzConfig {
    private static final String GENERATE_LOG4J_LOCATION_INFO = "netflix.blitz4j.generateLog4jLocationInfo";
    private static final String BLITZ4J_ASYNC_APPENDERS = "blitz4j.asyncAppenders";
    private static final String GENERATE_BLITZ4J_LOCATIONINFO = "netflix.blitz4j.generateBlitz4jLocationInfo";
    private static final String PROP_ASYNC_APPENDERS = "log4j.logger.asyncAppenders";
    private static final String NETFLIX_BLITZ4J_PRINT_LOGGING_ERRORS = "netflix.blitz4j.printLoggingErrors";
    private static final String NETFLIX_BLITZ4J_LOCKFREE = "netflix.blitz4j.lockfree";
    private Map<String, Object> propsMap = new ConcurrentHashMap<String, Object>();
    private Properties props;
    private static final DynamicPropertyFactory CONFIGURATION = DynamicPropertyFactory.getInstance();

    public DefaultBlitz4jConfig(Properties props) {
        this.props = props;
        if (this.props != null) {
            Enumeration<?> enumeration = this.props.propertyNames();
            while (enumeration.hasMoreElements()) {
                String key = (String)enumeration.nextElement();
                String propertyValue = props.getProperty(key);
                this.propsMap.put(key, propertyValue);
            }
        }
    }

    @Override
    public boolean shouldUseLockFree() {
        return CONFIGURATION.getBooleanProperty(NETFLIX_BLITZ4J_LOCKFREE, Boolean.valueOf(this.getPropertyValue(NETFLIX_BLITZ4J_LOCKFREE, "true")).booleanValue()).get();
    }

    @Override
    public boolean shouldPrintLoggingErrors() {
        return CONFIGURATION.getBooleanProperty(NETFLIX_BLITZ4J_PRINT_LOGGING_ERRORS, Boolean.valueOf(this.getPropertyValue(NETFLIX_BLITZ4J_PRINT_LOGGING_ERRORS, "false")).booleanValue()).get();
    }

    @Override
    public String[] getAsyncAppenders() {
        return CONFIGURATION.getStringProperty(PROP_ASYNC_APPENDERS, this.getPropertyValue(PROP_ASYNC_APPENDERS, "OFF")).get().split(",");
    }

    @Override
    public int getLogSummaryExpiry(String originalAppenderName) {
        return CONFIGURATION.getIntProperty("netflix.blitz4j." + originalAppenderName + ".discardEntryExpireSeconds", Integer.valueOf(this.getPropertyValue("netflix.blitz4j." + originalAppenderName + ".discardEntryExpireSeconds", "60")).intValue()).get();
    }

    @Override
    public int getLogSummarySize(String originalAppenderName) {
        return CONFIGURATION.getIntProperty("netflix.blitz4j." + originalAppenderName + ".discardMapSize", Integer.valueOf(this.getPropertyValue("netflix.blitz4j." + originalAppenderName + ".discardMapSize", "10000")).intValue()).get();
    }

    @Override
    public boolean shouldGenerateBlitz4jLocationInfo() {
        return CONFIGURATION.getBooleanProperty(GENERATE_BLITZ4J_LOCATIONINFO, Boolean.valueOf(this.getPropertyValue(GENERATE_BLITZ4J_LOCATIONINFO, "true")).booleanValue()).get();
    }

    @Override
    public boolean shouldGenerateLog4jLocationInfo() {
        return CONFIGURATION.getBooleanProperty(GENERATE_LOG4J_LOCATION_INFO, Boolean.valueOf(this.getPropertyValue(GENERATE_LOG4J_LOCATION_INFO, "false")).booleanValue()).get();
    }

    @Override
    public boolean shouldSummarizeOverflow(String originalAppenderName) {
        return CONFIGURATION.getBooleanProperty("netflix.blitz4j." + originalAppenderName + ".summarizeOverflow", Boolean.valueOf(this.getPropertyValue("netflix.blitz4j." + originalAppenderName + ".summarizeOverflow", "true")).booleanValue()).get();
    }

    @Override
    public String[] getAsyncAppenderImplementationNames() {
        return CONFIGURATION.getStringProperty(BLITZ4J_ASYNC_APPENDERS, this.getPropertyValue(BLITZ4J_ASYNC_APPENDERS, "com.netflix.blitz4j.AsyncAppender")).get().split(",");
    }

    @Override
    public int getBatcherQueueMaxMessages(String batcherName) {
        return CONFIGURATION.getIntProperty(batcherName + "." + "queue.maxMessages", Integer.valueOf(this.getPropertyValue(batcherName + "." + "queue.maxMessages", "10000")).intValue()).get();
    }

    @Override
    public int getBatchSize(String batcherName) {
        return CONFIGURATION.getIntProperty(batcherName + "." + "batch.maxMessages", Integer.valueOf(this.getPropertyValue(batcherName + "." + "batch.maxMessages", "30")).intValue()).get();
    }

    @Override
    public int getBatcherWaitTimeBeforeShutdown(String batcherName) {
        return CONFIGURATION.getIntProperty(batcherName + ".waitTimeinMillis", Integer.valueOf(this.getPropertyValue(batcherName + ".waitTimeinMillis", "10000")).intValue()).get();
    }

    @Override
    public double getBatcherMaxDelay(String batcherName) {
        return CONFIGURATION.getDoubleProperty(batcherName + "." + "batch.maxDelay", Double.valueOf(this.getPropertyValue(batcherName + ".waitTimeinMillis", "0.5")).doubleValue()).get();
    }

    @Override
    public boolean shouldWaitWhenBatcherQueueNotEmpty(String batcherName) {
        return CONFIGURATION.getBooleanProperty(batcherName + ".blocking", Boolean.valueOf(this.getPropertyValue(batcherName + ".blocking", "false")).booleanValue()).get();
    }

    @Override
    public int getBatcherMinThreads(String batcherName) {
        return CONFIGURATION.getIntProperty(batcherName + ".minThreads", Integer.valueOf(this.getPropertyValue(batcherName + ".minThreads", "1")).intValue()).get();
    }

    @Override
    public int getBatcherMaxThreads(String batcherName) {
        return CONFIGURATION.getIntProperty(batcherName + ".maxThreads", Integer.valueOf(this.getPropertyValue(batcherName + ".maxThreads", "3")).intValue()).get();
    }

    @Override
    public int getBatcherThreadKeepAliveTime(String batcherName) {
        return CONFIGURATION.getIntProperty(batcherName + ".keepAliveTime", Integer.valueOf(this.getPropertyValue(batcherName + ".keepAliveTime", "900")).intValue()).get();
    }

    @Override
    public boolean shouldRejectWhenAllBatcherThreadsUsed(String batcherName) {
        return CONFIGURATION.getBooleanProperty(batcherName + ".rejectWhenFull", Boolean.valueOf(this.getPropertyValue(batcherName + ".rejectWhenFull", "false")).booleanValue()).get();
    }

    private String getPropertyValue(String key, String defaultValue) {
        String value = (String)this.propsMap.get(key);
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    @Override
    public boolean shouldLoadLog4jPropertiesFromClassPath() {
        return CONFIGURATION.getBooleanProperty("netflix.blitz4j.shouldLoadLog4jProperties", Boolean.valueOf(this.getPropertyValue("netflix.blitz4j.shouldLoadLog4jProperties", "true")).booleanValue()).get();
    }
}

