/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.blitz4j;

import com.google.common.cache.CacheBuilder;
import com.netflix.blitz4j.BlitzConfig;
import com.netflix.blitz4j.LoggerCache;
import com.netflix.blitz4j.LoggingConfiguration;
import com.netflix.blitz4j.LoggingContext;
import com.netflix.logging.messaging.BatcherFactory;
import com.netflix.logging.messaging.MessageBatcher;
import com.netflix.logging.messaging.MessageProcessor;
import com.netflix.servo.annotations.DataSourceType;
import com.netflix.servo.annotations.Monitor;
import com.netflix.servo.monitor.DynamicCounter;
import com.netflix.servo.monitor.Monitors;
import com.netflix.servo.monitor.Stopwatch;
import com.netflix.servo.monitor.Timer;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Appender;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Logger;
import org.apache.log4j.helpers.AppenderAttachableImpl;
import org.apache.log4j.spi.AppenderAttachable;
import org.apache.log4j.spi.LocationInfo;
import org.apache.log4j.spi.LoggingEvent;

public class AsyncAppender
extends AppenderSkeleton
implements AppenderAttachable {
    private static final BlitzConfig CONFIGURATION = LoggingConfiguration.getInstance().getConfiguration();
    private static final int SLEEP_TIME_MS = 1;
    private static final String BATCHER_NAME_LIMITER = ".";
    private static final String APPENDER_NAME = "ASYNC";
    private MessageBatcher<LoggingEvent> batcher;
    private String originalAppenderName;
    private static final String LOGGER_ASYNC_APPENDER = "asyncAppenders";
    private AppenderAttachableImpl appenders = new AppenderAttachableImpl();
    private ConcurrentMap<String, LogSummary> logSummaryMap = new ConcurrentHashMap<String, LogSummary>();
    private Timer putBufferTimeTracer;
    private Timer putDiscardMapTimeTracer;
    private Timer locationInfoTimer;
    private Timer saveThreadLocalTimer;

    public AsyncAppender() {
        this.name = APPENDER_NAME;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.originalAppenderName == null ? 0 : this.originalAppenderName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        AsyncAppender other = (AsyncAppender)((Object)obj);
        return !(this.originalAppenderName == null ? other.originalAppenderName != null : !this.originalAppenderName.equals(other.originalAppenderName));
    }

    private void initBatcher(String appenderName) {
        MessageProcessor<LoggingEvent> messageProcessor = new MessageProcessor<LoggingEvent>(){

            @Override
            public void process(List<LoggingEvent> objects) {
                AsyncAppender.this.processLoggingEvents(objects);
            }
        };
        String batcherName = ((Object)((Object)this)).getClass().getName() + BATCHER_NAME_LIMITER + appenderName;
        this.batcher = BatcherFactory.createBatcher(batcherName, messageProcessor);
        this.batcher.setTarget(messageProcessor);
    }

    private void processLoggingEvents(List<LoggingEvent> loggingEvents) {
        while (this.appenders.getAllAppenders() == null) {
            if (this.batcher == null || this.batcher.isPaused()) {
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException ignore) {}
                continue;
            }
            Logger asyncLogger = LoggerCache.getInstance().getOrCreateLogger(LOGGER_ASYNC_APPENDER);
            Appender originalAppender = asyncLogger.getAppender(this.originalAppenderName);
            if (originalAppender == null) {
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException ignore) {}
                continue;
            }
            this.appenders.addAppender(originalAppender);
        }
        Iterator iter = this.logSummaryMap.entrySet().iterator();
        while (iter.hasNext()) {
            LogSummary logSummary;
            LoggingEvent event;
            Map.Entry mapEntry = iter.next();
            if (!this.batcher.isSpaceAvailable() || !this.batcher.process(event = (logSummary = (LogSummary)mapEntry.getValue()).createEvent())) break;
            iter.remove();
        }
        for (LoggingEvent event : loggingEvents) {
            this.appenders.appendLoopOnAppenders(event);
        }
    }

    public void append(LoggingEvent event) {
        boolean isBufferSpaceAvailable = this.batcher.isSpaceAvailable() && this.logSummaryMap.size() == 0;
        boolean isBufferPutSuccessful = false;
        LocationInfo locationInfo = null;
        Stopwatch s = this.locationInfoTimer.start();
        if (CONFIGURATION.shouldSummarizeOverflow(this.originalAppenderName)) {
            if (CONFIGURATION.shouldGenerateBlitz4jLocationInfo()) {
                locationInfo = LoggingContext.getInstance().generateLocationInfo(event);
            } else if (CONFIGURATION.shouldGenerateLog4jLocationInfo()) {
                locationInfo = event.getLocationInformation();
            }
        }
        s.stop();
        if (isBufferSpaceAvailable) {
            Stopwatch sThreadLocal = this.saveThreadLocalTimer.start();
            this.saveThreadLocalInfo(event);
            sThreadLocal.stop();
            isBufferPutSuccessful = this.putInBuffer(event);
        }
        if (CONFIGURATION.shouldSummarizeOverflow(this.originalAppenderName) && !isBufferPutSuccessful) {
            LogSummary summary;
            DynamicCounter.increment((String)(this.originalAppenderName + "_summarizeEvent"), (String[])new String[0]);
            Stopwatch t = this.putDiscardMapTimeTracer.start();
            String loggerKey = event.getLoggerName();
            if (locationInfo != null) {
                loggerKey = locationInfo.getClassName() + "_" + locationInfo.getLineNumber();
            }
            if ((summary = (LogSummary)this.logSummaryMap.get(loggerKey)) == null) {
                this.saveThreadLocalInfo(event);
                summary = new LogSummary(event);
                this.logSummaryMap.put(loggerKey, summary);
            } else {
                summary.add(event);
            }
            t.stop();
        } else if (!CONFIGURATION.shouldSummarizeOverflow(this.originalAppenderName) && !isBufferPutSuccessful) {
            DynamicCounter.increment((String)(this.originalAppenderName + "_discardEvent"), (String[])new String[0]);
        }
    }

    public void setOriginalAppenderName(String name) {
        block2: {
            this.originalAppenderName = name;
            this.initBatcher(this.originalAppenderName);
            this.putBufferTimeTracer = Monitors.newTimer((String)"putBuffer", (TimeUnit)TimeUnit.NANOSECONDS);
            this.putDiscardMapTimeTracer = Monitors.newTimer((String)"putDiscardMap", (TimeUnit)TimeUnit.NANOSECONDS);
            this.locationInfoTimer = Monitors.newTimer((String)"locationInfo", (TimeUnit)TimeUnit.NANOSECONDS);
            this.saveThreadLocalTimer = Monitors.newTimer((String)"saveThreadLocal", (TimeUnit)TimeUnit.NANOSECONDS);
            this.logSummaryMap = CacheBuilder.newBuilder().initialCapacity(5000).maximumSize((long)CONFIGURATION.getLogSummarySize(this.originalAppenderName)).expireAfterWrite((long)CONFIGURATION.getLogSummaryExpiry(this.originalAppenderName), TimeUnit.SECONDS).build().asMap();
            try {
                Monitors.registerObject((String)this.originalAppenderName, (Object)((Object)this));
            }
            catch (Throwable e) {
                if (!CONFIGURATION.shouldPrintLoggingErrors()) break block2;
                System.err.println("Cannot register monitor for AsyncAppender " + this.originalAppenderName);
                e.printStackTrace();
            }
        }
    }

    private void saveThreadLocalInfo(LoggingEvent event) {
        event.getNDC();
        event.getThreadName();
        event.getMDCCopy();
    }

    private boolean putInBuffer(LoggingEvent event) {
        DynamicCounter.increment((String)(this.originalAppenderName + "_putInBuffer"), (String[])new String[0]);
        Stopwatch t = this.putBufferTimeTracer.start();
        boolean hasPut = false;
        hasPut = this.batcher.process(event);
        t.stop();
        return hasPut;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        AppenderAttachableImpl appenderAttachableImpl = this.appenders;
        synchronized (appenderAttachableImpl) {
            this.appenders.removeAllAppenders();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration getAllAppenders() {
        AppenderAttachableImpl appenderAttachableImpl = this.appenders;
        synchronized (appenderAttachableImpl) {
            return this.appenders.getAllAppenders();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Appender getAppender(String name) {
        AppenderAttachableImpl appenderAttachableImpl = this.appenders;
        synchronized (appenderAttachableImpl) {
            return this.appenders.getAppender(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAttached(Appender appender) {
        AppenderAttachableImpl appenderAttachableImpl = this.appenders;
        synchronized (appenderAttachableImpl) {
            return this.appenders.isAttached(appender);
        }
    }

    public boolean requiresLayout() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllAppenders() {
        AppenderAttachableImpl appenderAttachableImpl = this.appenders;
        synchronized (appenderAttachableImpl) {
            this.appenders.removeAllAppenders();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAppender(Appender appender) {
        AppenderAttachableImpl appenderAttachableImpl = this.appenders;
        synchronized (appenderAttachableImpl) {
            this.appenders.removeAppender(appender);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAppender(String name) {
        AppenderAttachableImpl appenderAttachableImpl = this.appenders;
        synchronized (appenderAttachableImpl) {
            this.appenders.removeAppender(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAppender(Appender newAppender) {
        AppenderAttachableImpl appenderAttachableImpl = this.appenders;
        synchronized (appenderAttachableImpl) {
            this.appenders.addAppender(newAppender);
        }
    }

    @Monitor(name="discardMapSize", type=DataSourceType.GAUGE)
    public int getDiscadMapSize() {
        return this.logSummaryMap.size();
    }

    public void doAppend(LoggingEvent event) {
        this.append(event);
    }

    private static final class LogSummary {
        private LoggingEvent event;
        private int count = 1;

        public LogSummary(LoggingEvent event) {
            this.event = event;
        }

        public void add(LoggingEvent event) {
            ++this.count;
        }

        public LoggingEvent createEvent() {
            String msg = MessageFormat.format("{1}[Summarized {0} messages of this type because the internal buffer was full]", new Integer(this.count), this.event.getMessage());
            LoggingEvent loggingEvent = new LoggingEvent(this.event.getFQNOfLoggerClass(), this.event.getLogger(), this.event.getTimeStamp(), this.event.getLevel(), (Object)msg, Thread.currentThread().getName(), this.event.getThrowableInformation(), null, null, this.event.getProperties());
            return loggingEvent;
        }
    }
}

