/*
 * Decompiled with CFR 0.152.
 */
package com.namics.oss.spring.support.jpa;

import java.io.Serializable;
import java.time.LocalDateTime;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.MappedSuperclass;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import javax.persistence.Transient;
import javax.persistence.Version;

@MappedSuperclass
public class BaseEntity<ENTITY extends BaseEntity, PK extends Serializable>
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue
    private PK id;
    @Version
    private int versionId;
    private LocalDateTime creationDate;
    private LocalDateTime lastModifiedDate;

    @PreUpdate
    @PrePersist
    public void updateTimeStamps() {
        this.lastModifiedDate = LocalDateTime.now();
        if (this.creationDate == null) {
            this.creationDate = LocalDateTime.now();
        }
    }

    public int getVersionId() {
        return this.versionId;
    }

    public void setVersionId(int versionId) {
        this.versionId = versionId;
    }

    public LocalDateTime getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(LocalDateTime creationDate) {
        this.creationDate = creationDate;
    }

    public LocalDateTime getLastModifiedDate() {
        return this.lastModifiedDate;
    }

    public void setLastModifiedDate(LocalDateTime lastModifiedDate) {
        this.lastModifiedDate = lastModifiedDate;
    }

    public PK getId() {
        return this.id;
    }

    public void setId(PK id) {
        this.id = id;
    }

    @Transient
    public boolean isNew() {
        return null == this.getId();
    }

    public String toString() {
        return this.toStringBase();
    }

    public String toStringBase() {
        return this.getClass().getName() + "{id=" + this.id + ", versionId=" + this.versionId + ", creationDate=" + this.creationDate + ", lastModifiedDate=" + this.lastModifiedDate;
    }

    public boolean equals(Object obj) {
        if (null == obj) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        BaseEntity that = (BaseEntity)obj;
        return null == this.getId() ? false : this.getId().equals(that.getId());
    }

    public int hashCode() {
        int hashCode = 17;
        return hashCode += null == this.getId() ? 0 : this.getId().hashCode() * 31;
    }

    public ENTITY id(PK id) {
        this.setId(id);
        return this.self();
    }

    public ENTITY versionId(int versionId) {
        this.setVersionId(versionId);
        return this.self();
    }

    public ENTITY creationDate(LocalDateTime creationDate) {
        this.setCreationDate(creationDate);
        return this.self();
    }

    public ENTITY lastModifiedDate(LocalDateTime lastModifiedDate) {
        this.setLastModifiedDate(lastModifiedDate);
        return this.self();
    }

    public ENTITY self() {
        return (ENTITY)this;
    }
}

