/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.codegen.support;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class ClassUtils {
    public static String getName(Class<?> cl) {
        return ClassUtils.getName(cl, Collections.singleton("java.lang"), Collections.<String>emptySet());
    }

    public static String getFullName(Class<?> cl) {
        if (cl.isArray()) {
            return ClassUtils.getFullName(cl.getComponentType()) + "[]";
        }
        return cl.getCanonicalName();
    }

    public static String getPackageName(Class<?> cl) {
        if (cl.isArray()) {
            return ClassUtils.getPackageName(cl.getComponentType());
        }
        if (cl.getPackage() != null) {
            return cl.getPackage().getName();
        }
        return "";
    }

    public static String getName(Class<?> cl, Set<String> packages, Set<String> classes) {
        if (cl.isArray()) {
            return ClassUtils.getName(cl.getComponentType(), packages, classes) + "[]";
        }
        if (cl.getPackage() == null || packages.contains(cl.getPackage().getName()) || classes.contains(cl.getCanonicalName()) || classes.contains(cl.getCanonicalName().substring(0, cl.getName().lastIndexOf(46)))) {
            if (cl.getPackage() != null) {
                return cl.getCanonicalName().substring(cl.getPackage().getName().length() + 1);
            }
            return cl.getCanonicalName();
        }
        return cl.getCanonicalName();
    }

    public static Class<?> normalize(Class<?> clazz) {
        Class<?> zuper;
        if (List.class.isAssignableFrom(clazz)) {
            return List.class;
        }
        if (Set.class.isAssignableFrom(clazz)) {
            return Set.class;
        }
        if (Collection.class.isAssignableFrom(clazz)) {
            return Collection.class;
        }
        if (Map.class.isAssignableFrom(clazz)) {
            return Map.class;
        }
        if (clazz.getName().contains("$$") && (zuper = clazz.getSuperclass()) != null && !Object.class.equals(zuper)) {
            return zuper;
        }
        return clazz;
    }

    private ClassUtils() {
    }
}

