/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.codegen;

import com.google.common.base.Joiner;
import com.mysema.codegen.CodegenException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Set;
import java.util.jar.Manifest;
import javax.lang.model.SourceVersion;
import javax.tools.DiagnosticListener;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;

public class SimpleCompiler
implements JavaCompiler {
    private static final Joiner pathJoiner = Joiner.on((String)File.pathSeparator);
    private final ClassLoader classLoader;
    private String classPath;
    private final JavaCompiler compiler;

    public static String getClassPath(URLClassLoader cl) {
        try {
            ArrayList<String> paths = new ArrayList<String>();
            if (cl.getURLs().length == 1 && cl.getURLs()[0].getPath().contains("surefirebooter")) {
                URL url = cl.findResource("META-INF/MANIFEST.MF");
                Manifest manifest = new Manifest(url.openStream());
                String classpath = manifest.getMainAttributes().getValue("Class-Path");
                for (String entry : classpath.split(" ")) {
                    URL entryUrl = new URL(entry);
                    String decodedPath = URLDecoder.decode(entryUrl.getPath(), "UTF-8");
                    paths.add(new File(decodedPath).getAbsolutePath());
                }
            } else {
                for (URL url : cl.getURLs()) {
                    String decodedPath = URLDecoder.decode(url.getPath(), "UTF-8");
                    paths.add(new File(decodedPath).getAbsolutePath());
                }
            }
            return pathJoiner.join(paths);
        }
        catch (UnsupportedEncodingException e) {
            throw new CodegenException(e);
        }
        catch (IOException e) {
            throw new CodegenException(e);
        }
    }

    public SimpleCompiler() {
        this(ToolProvider.getSystemJavaCompiler(), Thread.currentThread().getContextClassLoader());
    }

    public SimpleCompiler(JavaCompiler compiler, ClassLoader classLoader) {
        this.compiler = compiler;
        this.classLoader = classLoader;
    }

    private String getClasspath() {
        if (this.classPath == null) {
            if (this.classLoader instanceof URLClassLoader) {
                this.classPath = SimpleCompiler.getClassPath((URLClassLoader)this.classLoader);
            } else {
                throw new IllegalArgumentException("Unsupported ClassLoader " + this.classLoader);
            }
        }
        return this.classPath;
    }

    @Override
    public Set<SourceVersion> getSourceVersions() {
        return this.compiler.getSourceVersions();
    }

    @Override
    public StandardJavaFileManager getStandardFileManager(DiagnosticListener<? super JavaFileObject> diagnosticListener, Locale locale, Charset charset) {
        return this.compiler.getStandardFileManager(diagnosticListener, locale, charset);
    }

    @Override
    public JavaCompiler.CompilationTask getTask(Writer out, JavaFileManager fileManager, DiagnosticListener<? super JavaFileObject> diagnosticListener, Iterable<String> options, Iterable<String> classes, Iterable<? extends JavaFileObject> compilationUnits) {
        return this.compiler.getTask(out, fileManager, diagnosticListener, options, classes, compilationUnits);
    }

    @Override
    public int isSupportedOption(String option) {
        return this.compiler.isSupportedOption(option);
    }

    @Override
    public int run(InputStream in, OutputStream out, OutputStream err, String ... arguments) {
        for (String a : arguments) {
            if (!a.equals("-classpath")) continue;
            return this.compiler.run(in, out, err, arguments);
        }
        ArrayList<String> args = new ArrayList<String>(arguments.length + 2);
        args.add("-classpath");
        args.add(this.getClasspath());
        for (String arg : arguments) {
            args.add(arg);
        }
        return this.compiler.run(in, out, err, args.toArray(new String[args.size()]));
    }
}

