/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.codegen;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;

public class MemJavaFileObject
extends SimpleJavaFileObject {
    private ByteArrayOutputStream baos;
    private final String name;

    public MemJavaFileObject(String urlPrefix, String name, JavaFileObject.Kind kind) {
        super(URI.create(urlPrefix + name + kind.extension), kind);
        this.name = name;
    }

    @Override
    public CharSequence getCharContent(boolean ignoreEncodingErrors) throws IOException {
        if (this.baos == null) {
            throw new FileNotFoundException(this.name);
        }
        return new String(this.baos.toByteArray());
    }

    @Override
    public String getName() {
        return this.name;
    }

    public byte[] getByteArray() {
        return this.baos.toByteArray();
    }

    @Override
    public InputStream openInputStream() throws IOException {
        if (this.baos == null) {
            throw new FileNotFoundException(this.name);
        }
        return new ByteArrayInputStream(this.baos.toByteArray());
    }

    @Override
    public OutputStream openOutputStream() throws IOException {
        if (this.baos == null) {
            this.baos = new ByteArrayOutputStream();
        }
        return this.baos;
    }
}

