/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.codegen;

import com.mysema.codegen.AbstractEvaluatorFactory;
import com.mysema.codegen.CodegenException;
import com.mysema.codegen.JavaWriter;
import com.mysema.codegen.MemFileManager;
import com.mysema.codegen.MemSourceFileObject;
import com.mysema.codegen.SimpleCompiler;
import com.mysema.codegen.model.ClassType;
import com.mysema.codegen.model.Parameter;
import com.mysema.codegen.model.SimpleType;
import com.mysema.codegen.model.Type;
import com.mysema.codegen.model.TypeCategory;
import com.mysema.codegen.support.ClassUtils;
import java.io.IOException;
import java.io.StringWriter;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.tools.JavaCompiler;
import javax.tools.StandardLocation;
import javax.tools.ToolProvider;

public class JDKEvaluatorFactory
extends AbstractEvaluatorFactory {
    private final MemFileManager fileManager;
    private final String classpath;
    private final List<String> compilationOptions;
    private final JavaCompiler compiler;

    public JDKEvaluatorFactory(URLClassLoader parent) {
        this(parent, ToolProvider.getSystemJavaCompiler());
    }

    public JDKEvaluatorFactory(URLClassLoader parent, JavaCompiler compiler) {
        this.fileManager = new MemFileManager(parent, compiler.getStandardFileManager(null, null, null));
        this.compiler = compiler;
        this.classpath = SimpleCompiler.getClassPath(parent);
        this.loader = this.fileManager.getClassLoader(StandardLocation.CLASS_OUTPUT);
        this.compilationOptions = Arrays.asList("-classpath", this.classpath, "-g:none");
    }

    @Override
    protected void compile(String source, ClassType projectionType, String[] names, Type[] types, String id, Map<String, Object> constants) throws IOException {
        StringWriter writer = new StringWriter();
        JavaWriter javaw = new JavaWriter(writer);
        SimpleType idType = new SimpleType(id, "", id, new Type[0]);
        javaw.beginClass(idType, null, new Type[0]);
        Parameter[] params = new Parameter[names.length];
        for (int i = 0; i < params.length; ++i) {
            params[i] = new Parameter(names[i], types[i]);
        }
        for (Map.Entry<String, Object> entry : constants.entrySet()) {
            ClassType type = new ClassType(TypeCategory.SIMPLE, ClassUtils.normalize(entry.getValue().getClass()), new Type[0]);
            javaw.publicField(type, entry.getKey());
        }
        if (constants.isEmpty()) {
            javaw.beginStaticMethod((Type)projectionType, "eval", params);
        } else {
            javaw.beginPublicMethod((Type)projectionType, "eval", params);
        }
        javaw.append(source);
        javaw.end();
        javaw.end();
        MemSourceFileObject javaFileObject = new MemSourceFileObject(id, writer.toString());
        StringWriter out = new StringWriter();
        JavaCompiler.CompilationTask task = this.compiler.getTask(out, this.fileManager, null, this.compilationOptions, null, Collections.singletonList(javaFileObject));
        if (!task.call().booleanValue()) {
            throw new CodegenException("Compilation of " + source + " failed.\n" + ((Object)out).toString());
        }
    }
}

