/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.codegen;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.ByteStreams;
import com.mysema.codegen.AbstractEvaluatorFactory;
import com.mysema.codegen.CodegenException;
import com.mysema.codegen.JavaWriter;
import com.mysema.codegen.MemFileManager;
import com.mysema.codegen.MemJavaFileObject;
import com.mysema.codegen.model.ClassType;
import com.mysema.codegen.model.Parameter;
import com.mysema.codegen.model.SimpleType;
import com.mysema.codegen.model.Type;
import com.mysema.codegen.model.TypeCategory;
import com.mysema.codegen.support.ClassUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;
import org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ClassFile;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.Compiler;
import org.eclipse.jdt.internal.compiler.DefaultErrorHandlingPolicies;
import org.eclipse.jdt.internal.compiler.ICompilerRequestor;
import org.eclipse.jdt.internal.compiler.IErrorHandlingPolicy;
import org.eclipse.jdt.internal.compiler.IProblemFactory;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFormatException;
import org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import org.eclipse.jdt.internal.compiler.env.NameEnvironmentAnswer;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblemFactory;
import org.eclipse.jdt.internal.compiler.tool.EclipseFileManager;

public class ECJEvaluatorFactory
extends AbstractEvaluatorFactory {
    private final MemFileManager fileManager;
    private final ClassLoader parentClassLoader;
    private final List<String> problemList = Lists.newArrayList();
    private final CompilerOptions compilerOptions;

    public static CompilerOptions getDefaultCompilerOptions() {
        String javaSpecVersion = System.getProperty("java.specification.version");
        HashMap settings = Maps.newHashMap();
        settings.put("org.eclipse.jdt.core.compiler.source", javaSpecVersion);
        settings.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", javaSpecVersion);
        settings.put("org.eclipse.jdt.core.compiler.problem.deprecation", "ignore");
        return new CompilerOptions((Map)settings);
    }

    public ECJEvaluatorFactory(ClassLoader parent) {
        this(parent, ECJEvaluatorFactory.getDefaultCompilerOptions());
    }

    public ECJEvaluatorFactory(ClassLoader parent, CompilerOptions compilerOptions) {
        this.parentClassLoader = parent;
        this.fileManager = new MemFileManager(parent, (StandardJavaFileManager)new EclipseFileManager(Locale.getDefault(), Charset.defaultCharset()));
        this.loader = this.fileManager.getClassLoader(StandardLocation.CLASS_OUTPUT);
        this.compilerOptions = compilerOptions;
    }

    @Override
    protected void compile(String source, ClassType projectionType, String[] names, Type[] types, String id, Map<String, Object> constants) throws IOException {
        StringWriter writer = new StringWriter();
        JavaWriter javaw = new JavaWriter(writer);
        SimpleType idType = new SimpleType(id, "", id, new Type[0]);
        javaw.beginClass(idType, null, new Type[0]);
        Parameter[] params = new Parameter[names.length];
        for (int i = 0; i < params.length; ++i) {
            params[i] = new Parameter(names[i], types[i]);
        }
        for (Map.Entry<String, Object> entry : constants.entrySet()) {
            ClassType type = new ClassType(TypeCategory.SIMPLE, ClassUtils.normalize(entry.getValue().getClass()), new Type[0]);
            javaw.publicField(type, entry.getKey());
        }
        if (constants.isEmpty()) {
            javaw.beginStaticMethod((Type)projectionType, "eval", params);
        } else {
            javaw.beginPublicMethod((Type)projectionType, "eval", params);
        }
        javaw.append(source);
        javaw.end();
        javaw.end();
        final char[] targetContents = writer.toString().toCharArray();
        final String targetName = idType.getFullName();
        final ICompilationUnit[] targetCompilationUnits = new ICompilationUnit[]{new ICompilationUnit(){

            public char[] getContents() {
                return targetContents;
            }

            public char[] getMainTypeName() {
                int dot = targetName.lastIndexOf(46);
                if (dot > 0) {
                    return targetName.substring(dot + 1).toCharArray();
                }
                return targetName.toCharArray();
            }

            public char[][] getPackageName() {
                StringTokenizer tok = new StringTokenizer(targetName, ".");
                char[][] result = new char[tok.countTokens() - 1][];
                for (int j = 0; j < result.length; ++j) {
                    result[j] = tok.nextToken().toCharArray();
                }
                return result;
            }

            public char[] getFileName() {
                return CharOperation.concat((char[])targetName.toCharArray(), (char[])".java".toCharArray());
            }
        }};
        INameEnvironment env = new INameEnvironment(){

            private String join(char[][] compoundName, char separator) {
                if (compoundName == null) {
                    return "";
                }
                ArrayList parts = Lists.newArrayListWithCapacity((int)compoundName.length);
                for (char[] part : compoundName) {
                    parts.add(new String(part));
                }
                return Joiner.on((char)separator).join((Iterable)parts);
            }

            public NameEnvironmentAnswer findType(char[][] compoundTypeName) {
                return this.findType(this.join(compoundTypeName, '.'));
            }

            public NameEnvironmentAnswer findType(char[] typeName, char[][] packageName) {
                return this.findType(CharOperation.arrayConcat((char[][])packageName, (char[])typeName));
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private boolean isClass(String result) {
                if (Strings.isNullOrEmpty((String)result)) {
                    return false;
                }
                if (result.equals(targetName)) {
                    return true;
                }
                InputStream is = null;
                try {
                    is = ECJEvaluatorFactory.this.loader.getResourceAsStream(result);
                    if (is == null) {
                        String resourceName = result.replace('.', '/') + ".class";
                        is = ECJEvaluatorFactory.this.parentClassLoader.getResourceAsStream(resourceName);
                        if (is == null && !result.contains(".")) {
                            is = ECJEvaluatorFactory.this.parentClassLoader.getResourceAsStream("java/lang/" + resourceName);
                        }
                    }
                    if (is == null) {
                        boolean bl = false;
                        return bl;
                    }
                    boolean bl = true;
                    return bl;
                }
                finally {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException ex) {}
                    }
                }
            }

            public boolean isPackage(char[][] parentPackageName, char[] packageName) {
                String parent = this.join(parentPackageName, '.');
                if (this.isClass(parent)) {
                    return false;
                }
                String qualifiedName = (parent.isEmpty() ? "" : parent + ".") + new String(packageName);
                return !this.isClass(qualifiedName);
            }

            public void cleanup() {
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            private NameEnvironmentAnswer findType(String className) {
                String resourceName = className.replace('.', '/') + ".class";
                InputStream is = null;
                try {
                    if (className.equals(targetName)) {
                        NameEnvironmentAnswer nameEnvironmentAnswer = new NameEnvironmentAnswer(targetCompilationUnits[0], null);
                        return nameEnvironmentAnswer;
                    }
                    is = ECJEvaluatorFactory.this.loader.getResourceAsStream(resourceName);
                    if (is == null) {
                        is = ECJEvaluatorFactory.this.parentClassLoader.getResourceAsStream(resourceName);
                    }
                    if (is != null) {
                        ClassFileReader cfr = new ClassFileReader(ByteStreams.toByteArray((InputStream)is), className.toCharArray(), true);
                        NameEnvironmentAnswer e = new NameEnvironmentAnswer((IBinaryType)cfr, null);
                        return e;
                    }
                    NameEnvironmentAnswer cfr = null;
                    return cfr;
                }
                catch (ClassFormatException ex) {
                    throw new RuntimeException(ex);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                finally {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException e) {}
                    }
                }
            }
        };
        ICompilerRequestor requestor = new ICompilerRequestor(){

            public void acceptResult(CompilationResult result) {
                if (result.hasErrors()) {
                    for (CategorizedProblem problem : result.getProblems()) {
                        if (!problem.isError()) continue;
                        ECJEvaluatorFactory.this.problemList.add(problem.getMessage());
                    }
                } else {
                    for (ClassFile clazz : result.getClassFiles()) {
                        try {
                            MemJavaFileObject jfo = (MemJavaFileObject)ECJEvaluatorFactory.this.fileManager.getJavaFileForOutput(StandardLocation.CLASS_OUTPUT, new String(clazz.fileName()), JavaFileObject.Kind.CLASS, null);
                            OutputStream os = jfo.openOutputStream();
                            os.write(clazz.getBytes());
                        }
                        catch (IOException ex) {
                            throw new RuntimeException(ex);
                        }
                    }
                }
            }
        };
        this.problemList.clear();
        IErrorHandlingPolicy policy = DefaultErrorHandlingPolicies.exitAfterAllProblems();
        DefaultProblemFactory problemFactory = new DefaultProblemFactory(Locale.getDefault());
        try {
            Compiler compiler = new Compiler(env, policy, this.compilerOptions, requestor, (IProblemFactory)problemFactory);
            compiler.compile(targetCompilationUnits);
            if (!this.problemList.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                for (String problem : this.problemList) {
                    sb.append("\t").append(problem).append("\n");
                }
                throw new CodegenException("Compilation of " + id + " failed:\n" + source + "\n" + sb.toString());
            }
        }
        catch (RuntimeException ex) {
            Throwable cause = ex.getCause();
            if (cause != null) {
                if (cause instanceof IOException) {
                    throw (IOException)cause;
                }
                if (cause instanceof ClassFormatException) {
                    throw new IOException(cause);
                }
            }
            throw ex;
        }
    }

    public CompilerOptions getCompilerOptions() {
        return this.compilerOptions;
    }
}

