/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.codegen;

import com.mysema.codegen.CodegenException;
import com.mysema.codegen.Evaluator;
import com.mysema.codegen.EvaluatorFactory;
import com.mysema.codegen.MethodEvaluator;
import com.mysema.codegen.model.ClassType;
import com.mysema.codegen.model.Type;
import com.mysema.codegen.model.TypeCategory;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Map;

public abstract class AbstractEvaluatorFactory
implements EvaluatorFactory {
    protected ClassLoader loader;

    protected abstract void compile(String var1, ClassType var2, String[] var3, Type[] var4, String var5, Map<String, Object> var6) throws IOException;

    @Override
    public <T> Evaluator<T> createEvaluator(String source, Class<? extends T> projectionType, String[] names, Class<?>[] classes, Map<String, Object> constants) {
        Type[] types = new Type[classes.length];
        for (int i = 0; i < types.length; ++i) {
            types[i] = new ClassType(TypeCategory.SIMPLE, classes[i], new Type[0]);
        }
        return this.createEvaluator(source, new ClassType(TypeCategory.SIMPLE, projectionType, new Type[0]), names, types, classes, constants);
    }

    @Override
    public <T> Evaluator<T> createEvaluator(String source, ClassType projection, String[] names, Type[] types, Class<?>[] classes, Map<String, Object> constants) {
        try {
            Class<?> clazz;
            String id = this.toId(source, projection.getJavaClass(), types, constants.values());
            try {
                clazz = this.loader.loadClass(id);
            }
            catch (ClassNotFoundException e) {
                this.compile(source, projection, names, types, id, constants);
                clazz = this.loader.loadClass(id);
            }
            Object object = !constants.isEmpty() ? clazz.newInstance() : null;
            for (Map.Entry<String, Object> entry : constants.entrySet()) {
                Field field = clazz.getField(entry.getKey());
                field.set(object, entry.getValue());
            }
            Method method = clazz.getMethod("eval", classes);
            return new MethodEvaluator(method, object, projection.getJavaClass());
        }
        catch (ClassNotFoundException e) {
            throw new CodegenException(e);
        }
        catch (SecurityException e) {
            throw new CodegenException(e);
        }
        catch (NoSuchMethodException e) {
            throw new CodegenException(e);
        }
        catch (NoSuchFieldException e) {
            throw new CodegenException(e);
        }
        catch (InstantiationException e) {
            throw new CodegenException(e);
        }
        catch (IOException e) {
            throw new CodegenException(e);
        }
        catch (IllegalAccessException e) {
            throw new CodegenException(e);
        }
    }

    protected String toId(String source, Class<?> returnType, Type[] types, Collection<Object> constants) {
        StringBuilder b = new StringBuilder("Q");
        b.append("_").append(source.hashCode());
        b.append("_").append(returnType.getName().hashCode());
        for (Type type : types) {
            b.append("_").append(type.getFullName().hashCode());
        }
        for (Object constant : constants) {
            b.append("_").append(constant.getClass().getName().hashCode());
        }
        return b.toString().replace('-', '0');
    }
}

