/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.mojo.license.util.resource;

import com.google.code.mojo.license.util.resource.CustomClassLoader;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import org.apache.maven.plugin.MojoFailureException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ResourceFinder {
    private final File basedir;
    private CustomClassLoader compileClassPath;
    private CustomClassLoader pluginClassPath;

    public ResourceFinder(File basedir) {
        this.basedir = basedir;
    }

    public void setCompileClassPath(List<String> classpath) {
        this.compileClassPath = new CustomClassLoader();
        if (classpath != null) {
            for (String absolutePath : classpath) {
                this.compileClassPath.addFolder(absolutePath);
            }
        }
    }

    public void setPluginClassPath(ClassLoader classLoader) {
        this.pluginClassPath = new CustomClassLoader(classLoader);
    }

    public URL findResource(String resource) throws MojoFailureException {
        URL res = this.toURL(new File(this.basedir, resource));
        if (res != null) {
            return res;
        }
        res = this.toURL(new File(resource));
        if (res != null) {
            return res;
        }
        String cpResource = resource.startsWith("/") ? resource.substring(1) : resource;
        res = this.compileClassPath.getResource(cpResource);
        if (res != null) {
            return res;
        }
        res = this.pluginClassPath.getResource(cpResource);
        if (res != null) {
            return res;
        }
        try {
            res = new URL(resource);
            res.openStream().close();
            return res;
        }
        catch (Exception e) {
            throw new MojoFailureException("Resource " + resource + " not found in file system, classpath or URL: " + e.getMessage(), (Throwable)e);
        }
    }

    private URL toURL(File file) {
        if (file.exists() && file.canRead()) {
            try {
                return file.toURI().toURL();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return null;
    }
}

