/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.mojo.license.util;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import org.codehaus.plexus.util.DirectoryScanner;

public final class Selection {
    private final File basedir;
    private final String[] included;
    private final String[] excluded;
    private DirectoryScanner scanner;
    static final String[] DEFAULT_INCLUDE = new String[]{"**"};
    static final String[] DEFAULT_EXCLUDES = new String[]{"**/*~", "**/#*#", "**/.#*", "**/%*%", "**/._*", "**/.repository/**", "**/CVS", "**/CVS/**", "**/.cvsignore", "**/RCS", "**/RCS/**", "**/SCCS", "**/SCCS/**", "**/vssver.scc", "**/.svn", "**/.svn/**", "**/.arch-ids", "**/.arch-ids/**", "**/.bzr", "**/.bzr/**", "**/.MySCMServerInfo", "**/.DS_Store", "**/.metadata", "**/.metadata/**", "**/.hg", "**/.hg/**", "**/.git", "**/.git/**", "**/BitKeeper", "**/BitKeeper/**", "**/ChangeSet", "**/ChangeSet/**", "**/_darcs", "**/_darcs/**", "**/.darcsrepo", "**/.darcsrepo/**", "**/-darcs-backup*", "**/.darcs-temp-mail", "**/target/**", "**/test-output/**", "**/release.properties", "**/pom.xml", "**/dependency-reduced-pom.xml", "**/cobertura.ser", "**/.clover/**", "**/.classpath", "**/.project", "**/.settings/**", "**/*.iml", "**/*.ipr", "**/*.iws", "**/MANIFEST.MF", "**/*.jpg", "**/*.png", "**/*.gif", "**/*.ico", "**/*.bmp", "**/*.tiff", "**/*.tif", "**/*.cr2", "**/*.xcf", "**/*.class", "**/*.exe", "**/*.md5", "**/*.sha1", "**/*.jar", "**/*.zip", "**/*.rar", "**/*.tar", "**/*.tar.gz", "**/*.tar.bz2", "**/*.gz", "**/*.xls", "**/META-INF/services/**"};

    public Selection(File basedir, String[] included, String[] excluded, boolean useDefaultExcludes) {
        this.basedir = basedir;
        this.included = Selection.buildInclusions(included);
        this.excluded = Selection.buildExclusions(useDefaultExcludes, excluded);
    }

    public String[] getSelectedFiles() {
        this.scanIfneeded();
        return this.scanner.getIncludedFiles();
    }

    public File getBasedir() {
        return this.basedir;
    }

    public String[] getIncluded() {
        return this.included;
    }

    public String[] getExcluded() {
        return this.excluded;
    }

    private void scanIfneeded() {
        if (this.scanner == null) {
            this.scanner = new DirectoryScanner();
            this.scanner.setBasedir(this.basedir);
            this.scanner.setIncludes(this.included);
            this.scanner.setExcludes(this.excluded);
            this.scanner.scan();
        }
    }

    private static String[] buildExclusions(boolean useDefaultExcludes, String ... excludes) {
        ArrayList<String> exclusions = new ArrayList<String>();
        if (useDefaultExcludes) {
            exclusions.addAll(Arrays.asList(DEFAULT_EXCLUDES));
        }
        if (excludes != null && excludes.length > 0) {
            exclusions.addAll(Arrays.asList(excludes));
        }
        return exclusions.toArray(new String[exclusions.size()]);
    }

    private static String[] buildInclusions(String ... includes) {
        return includes != null && includes.length > 0 ? includes : DEFAULT_INCLUDE;
    }
}

