/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.mojo.license.header;

import com.google.code.mojo.license.HeaderSection;
import com.google.code.mojo.license.header.HeaderDefinition;
import com.google.code.mojo.license.util.FileUtils;
import com.google.code.mojo.license.util.StringUtils;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Header {
    private final URL location;
    private final String headerContent;
    private final String headerContentOneLine;
    private String[] lines;
    private final HeaderSection[] sections;
    private static final Map<String, String> EMPTY_PROPERTIES = new HashMap<String, String>(0);

    public Header(URL location, Map<String, String> properties, HeaderSection[] sections) {
        if (location == null) {
            throw new IllegalArgumentException("Cannot read license template header file with a null location");
        }
        if (properties == null) {
            properties = EMPTY_PROPERTIES;
        }
        this.location = location;
        this.sections = sections;
        try {
            this.headerContent = FileUtils.read(location, properties);
            this.lines = this.headerContent.replace("\r", "").split("\n");
            this.headerContentOneLine = FileUtils.remove(this.headerContent, " ", "\t", "\r", "\n");
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Cannot read header document " + location + ". Cause: " + e.getMessage(), e);
        }
    }

    public String asString() {
        return this.headerContent;
    }

    public String asOneLineString() {
        return this.headerContentOneLine;
    }

    public int getLineCount() {
        return this.lines.length;
    }

    public URL getLocation() {
        return this.location;
    }

    public String eol(boolean unix) {
        return unix ? "\n" : "\r\n";
    }

    public String buildForDefinition(HeaderDefinition type, boolean unix) {
        StringBuilder newHeader = new StringBuilder();
        if (this.notEmpty(type.getFirstLine())) {
            newHeader.append(type.getFirstLine().replace("EOL", this.eol(unix)));
            newHeader.append(this.eol(unix));
        }
        for (String line : this.getLines()) {
            String str = type.getBeforeEachLine().replace("EOL", this.eol(unix)) + line;
            newHeader.append(StringUtils.rtrim(str));
            newHeader.append(this.eol(unix));
        }
        if (this.notEmpty(type.getEndLine())) {
            newHeader.append(type.getEndLine().replace("EOL", this.eol(unix)));
            newHeader.append(this.eol(unix));
        }
        return newHeader.toString();
    }

    public String toString() {
        return this.asString();
    }

    public String[] getLines() {
        return this.lines;
    }

    public boolean isMatchForText(String potentialFileHeader, HeaderDefinition headerDefinition, boolean unix) {
        String expected = this.buildForDefinition(headerDefinition, unix);
        SortedMap<Integer, HeaderSection> sectionsByIndex = this.computeSectionsByIndex(expected);
        if (sectionsByIndex.isEmpty()) {
            return potentialFileHeader.contains(expected);
        }
        List<String> textBetweenSections = this.buildExpectedTextBetweenSections(expected, sectionsByIndex);
        ArrayList<HeaderSection> sectionsInOrder = new ArrayList<HeaderSection>(sectionsByIndex.values());
        return this.recursivelyFindMatch(potentialFileHeader, headerDefinition, textBetweenSections, sectionsInOrder, 0, 0);
    }

    public String applyDefinitionAndSections(HeaderDefinition headerDefinition, boolean unix) {
        String expected = this.buildForDefinition(headerDefinition, unix);
        SortedMap<Integer, HeaderSection> sectionsByIndex = this.computeSectionsByIndex(expected);
        if (sectionsByIndex.isEmpty()) {
            return expected;
        }
        List<String> textBetweenSections = this.buildExpectedTextBetweenSections(expected, sectionsByIndex);
        ArrayList<HeaderSection> sectionsInOrder = new ArrayList<HeaderSection>(sectionsByIndex.values());
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < textBetweenSections.size(); ++i) {
            HeaderSection section;
            String sectionValue;
            String textBetween = textBetweenSections.get(i);
            b.append(textBetween);
            if (i >= sectionsInOrder.size() || !this.notEmpty(sectionValue = (section = (HeaderSection)sectionsInOrder.get(i)).getDefaultValue())) continue;
            String[] tokens = sectionValue.split(this.eol(unix));
            for (int j = 0; j < tokens.length; ++j) {
                if (j > 0) {
                    b.append(this.eol(unix));
                    if (this.notEmpty(headerDefinition.getBeforeEachLine())) {
                        b.append(headerDefinition.getBeforeEachLine());
                    }
                }
                b.append(tokens[j]);
            }
        }
        return b.toString();
    }

    private boolean notEmpty(String str) {
        return str != null && str.length() > 0;
    }

    private SortedMap<Integer, HeaderSection> computeSectionsByIndex(String expectedHeaderText) {
        TreeMap<Integer, HeaderSection> sectionsByIndex = new TreeMap<Integer, HeaderSection>();
        if (this.sections == null) {
            return sectionsByIndex;
        }
        for (HeaderSection section : this.sections) {
            String key = section.getKey();
            int index = expectedHeaderText.indexOf(key);
            if (index == -1) continue;
            int indexEnd = index + section.getKey().length();
            for (Map.Entry entry : sectionsByIndex.entrySet()) {
                int existingIndexStart = (Integer)entry.getKey();
                HeaderSection existingSection = (HeaderSection)entry.getValue();
                int existingIndexEnd = existingIndexStart + existingSection.getKey().length();
                if (existingIndexStart < indexEnd && index < existingIndexEnd) {
                    throw new IllegalArgumentException(String.format("Existing section '%1$s' overlaps with new section '%2$s'", existingSection.getKey(), section.getKey()));
                }
                sectionsByIndex.put(index, section);
            }
            sectionsByIndex.put(index, section);
        }
        return sectionsByIndex;
    }

    private List<String> buildExpectedTextBetweenSections(String expectedHeaderText, SortedMap<Integer, HeaderSection> sectionsByIndex) {
        ArrayList<String> textBetweenSections = new ArrayList<String>();
        int currentIndex = 0;
        for (Map.Entry<Integer, HeaderSection> entry : sectionsByIndex.entrySet()) {
            int index = entry.getKey();
            HeaderSection section = entry.getValue();
            String textBetween = expectedHeaderText.substring(currentIndex, index);
            textBetweenSections.add(textBetween);
            currentIndex = index + section.getKey().length();
        }
        String textBetween = expectedHeaderText.substring(currentIndex, expectedHeaderText.length());
        textBetweenSections.add(textBetween);
        return textBetweenSections;
    }

    private boolean recursivelyFindMatch(String potentialFileHeader, HeaderDefinition headerDefinition, List<String> expectedTextBetweenSections, List<HeaderSection> sectionsInOrder, int currentTextSegmentIndex, int currentPotentialFileHeaderIndex) {
        if (currentTextSegmentIndex == expectedTextBetweenSections.size()) {
            return true;
        }
        int currentSearchFromIndex = currentPotentialFileHeaderIndex;
        String expectedText;
        int index;
        while ((index = potentialFileHeader.indexOf(expectedText = expectedTextBetweenSections.get(currentTextSegmentIndex), currentSearchFromIndex)) != -1) {
            String sectionValue;
            HeaderSection section;
            if (currentTextSegmentIndex > 0 && !this.ensureSectionMatch(headerDefinition, section = sectionsInOrder.get(currentTextSegmentIndex - 1), sectionValue = potentialFileHeader.substring(currentPotentialFileHeaderIndex, index))) {
                return false;
            }
            if (this.recursivelyFindMatch(potentialFileHeader, headerDefinition, expectedTextBetweenSections, sectionsInOrder, currentTextSegmentIndex + 1, index + expectedText.length())) {
                return true;
            }
            currentSearchFromIndex = index + 1;
        }
        return false;
    }

    private boolean ensureSectionMatch(HeaderDefinition headerDefinition, HeaderSection section, String sectionValue) {
        String match = section.getEnsureMatch();
        if (!this.notEmpty(match)) {
            return true;
        }
        String[] lines = sectionValue.split("\n");
        String before = headerDefinition.getBeforeEachLine();
        if (this.notEmpty(before)) {
            for (int i = 0; i < lines.length; ++i) {
                String line = lines[i];
                if (!line.startsWith(before)) continue;
                lines[i] = line.substring(before.length());
            }
        }
        if (section.isMultiLineMatch()) {
            StringBuilder b = new StringBuilder();
            for (int i = 0; i < lines.length; ++i) {
                if (i > 0) {
                    b.append('\n');
                }
                b.append(lines[i]);
            }
            String multiLineValue = b.toString();
            return multiLineValue.matches(match);
        }
        for (String line : lines) {
            if (line.matches(match)) continue;
            return false;
        }
        return true;
    }
}

