/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.mojo.license.document;

import com.google.code.mojo.license.document.Document;
import com.google.code.mojo.license.header.HeaderDefinition;
import java.io.File;
import java.util.Map;
import org.codehaus.plexus.util.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DocumentFactory {
    private final Map<String, String> mapping;
    private final Map<String, HeaderDefinition> definitions;
    private final File basedir;
    private final String encoding;
    private final String[] keywords;

    public DocumentFactory(File basedir, Map<String, String> mapping, Map<String, HeaderDefinition> definitions, String encoding, String[] keywords) {
        this.mapping = mapping;
        this.definitions = definitions;
        this.basedir = basedir;
        this.encoding = encoding;
        this.keywords = (String[])keywords.clone();
    }

    public Document createDocuments(String file) {
        return this.getWrapper(file, this.encoding);
    }

    private Document getWrapper(String file, String encoding) {
        String headerType = this.mapping.get(FileUtils.extension((String)file).toLowerCase());
        headerType = headerType == null ? this.mapping.get("") : headerType.toLowerCase();
        return new Document(new File(this.basedir, file), this.definitions.get(headerType), encoding, this.keywords);
    }
}

