/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.mojo.license;

import com.google.code.mojo.license.AbstractLicenseMojo;
import com.google.code.mojo.license.Callback;
import com.google.code.mojo.license.document.Document;
import com.google.code.mojo.license.header.Header;
import java.io.File;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;

public final class LicenseFormatMojo
extends AbstractLicenseMojo {
    protected boolean dryRun = false;
    protected boolean skipExistingHeaders = false;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)"Updating license headers...");
        this.execute(new Callback(){

            public void onHeaderNotFound(Document document, Header header) {
                document.parseHeader();
                if (document.headerDetected()) {
                    if (LicenseFormatMojo.this.skipExistingHeaders) {
                        LicenseFormatMojo.this.debug("Keeping license header in: %s", document.getFile());
                        return;
                    }
                    document.removeHeader();
                }
                LicenseFormatMojo.this.info("Updating license header in: %s", document.getFile());
                document.updateHeader(header);
                if (!LicenseFormatMojo.this.dryRun) {
                    document.save();
                } else {
                    String name = document.getFile().getName() + ".licensed";
                    File copy = new File(document.getFile().getParentFile(), name);
                    LicenseFormatMojo.this.info("Result saved to: %s", copy);
                    document.saveTo(copy);
                }
            }

            public void onExistingHeader(Document document, Header header) {
                LicenseFormatMojo.this.debug("Header OK in: %s", document.getFile());
            }
        });
    }
}

