/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.mojo.license;

import com.google.code.mojo.license.AbstractLicenseMojo;
import com.google.code.mojo.license.Callback;
import com.google.code.mojo.license.document.Document;
import com.google.code.mojo.license.header.Header;
import java.io.File;
import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;

public final class LicenseCheckMojo
extends AbstractLicenseMojo {
    protected boolean failIfMissing = true;
    public final Collection<File> missingHeaders = new ConcurrentLinkedQueue<File>();

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)"Checking licenses...");
        this.missingHeaders.clear();
        this.execute(new Callback(){

            public void onHeaderNotFound(Document document, Header header) {
                LicenseCheckMojo.this.info("Missing header in: %s", document.getFile());
                LicenseCheckMojo.this.missingHeaders.add(document.getFile());
            }

            public void onExistingHeader(Document document, Header header) {
                LicenseCheckMojo.this.debug("Header OK in: %s", document.getFile());
            }
        });
        if (!this.missingHeaders.isEmpty()) {
            if (this.failIfMissing) {
                throw new MojoExecutionException("Some files do not have the expected license header");
            }
            this.getLog().warn((CharSequence)"Some files do not have the expected license header");
        }
    }
}

