/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.mojo.license;

import com.google.code.mojo.license.Callback;
import com.google.code.mojo.license.HeaderSection;
import com.google.code.mojo.license.document.Document;
import com.google.code.mojo.license.document.DocumentFactory;
import com.google.code.mojo.license.document.DocumentType;
import com.google.code.mojo.license.header.AdditionalHeaderDefinition;
import com.google.code.mojo.license.header.Header;
import com.google.code.mojo.license.header.HeaderDefinition;
import com.google.code.mojo.license.header.HeaderType;
import com.google.code.mojo.license.util.Selection;
import com.google.code.mojo.license.util.resource.ResourceFinder;
import com.mycila.xmltool.XMLDoc;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractLicenseMojo
extends AbstractMojo {
    protected File basedir;
    protected String header;
    protected String[] validHeaders = new String[0];
    protected String[] headerDefinitions = new String[0];
    protected HeaderSection[] headerSections = new HeaderSection[0];
    protected Map<String, String> properties = new HashMap<String, String>();
    protected String[] includes = new String[0];
    protected String[] excludes = new String[0];
    protected String[] keywords = new String[]{"copyright"};
    protected boolean useDefaultExcludes = true;
    protected boolean aggregate = false;
    protected Map<String, String> mapping = new HashMap<String, String>();
    protected boolean useDefaultMapping = true;
    protected float concurrencyFactor = 1.5f;
    protected boolean skip = false;
    protected boolean quiet = false;
    protected boolean strictCheck = false;
    protected String encoding = System.getProperty("file.encoding");
    protected MavenProject project = new MavenProject();
    private ResourceFinder finder;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected final void execute(final Callback callback) throws MojoExecutionException, MojoFailureException {
        if (this.skip) return;
        if (this.header == null) {
            this.warn("No header file specified to check for license", new Object[0]);
            return;
        }
        if (!this.strictCheck) {
            this.warn("Property 'strictCheck' is not enabled. Please consider adding <strictCheck>true</strictCheck> in your pom.xml file.", new Object[0]);
            this.warn("See http://code.google.com/p/maven-license-plugin/wiki/Configuration for more information.", new Object[0]);
        }
        this.finder = new ResourceFinder(this.basedir);
        try {
            this.finder.setCompileClassPath(this.project.getCompileClasspathElements());
        }
        catch (DependencyResolutionRequiredException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
        this.finder.setPluginClassPath(((Object)((Object)this)).getClass().getClassLoader());
        final Header h = new Header(this.finder.findResource(this.header), this.mergeProperties(), this.headerSections);
        this.debug("Header %s:\n%s", h.getLocation(), h);
        if (this.validHeaders == null) {
            this.validHeaders = new String[0];
        }
        final ArrayList<Header> validHeaders = new ArrayList<Header>(this.validHeaders.length);
        for (String validHeader : this.validHeaders) {
            validHeaders.add(new Header(this.finder.findResource(validHeader), this.mergeProperties(), this.headerSections));
        }
        final DocumentFactory documentFactory = new DocumentFactory(this.basedir, this.buildMapping(), this.buildHeaderDefinitions(), this.encoding, this.keywords);
        int nThreads = (int)((float)Runtime.getRuntime().availableProcessors() * this.concurrencyFactor);
        ExecutorService executorService = Executors.newFixedThreadPool(nThreads);
        ExecutorCompletionService completionService = new ExecutorCompletionService(executorService);
        int count = 0;
        this.debug("Number of execution threads: %s", nThreads);
        try {
            for (final String file : this.listSelectedFiles()) {
                completionService.submit(new Runnable(){

                    public void run() {
                        Document document = documentFactory.createDocuments(file);
                        AbstractLicenseMojo.this.debug("Selected file: %s [header style: %s]", document.getFile(), document.getHeaderDefinition());
                        if (document.isNotSupported()) {
                            AbstractLicenseMojo.this.warn("Unknown file extension: %s", document.getFile());
                        } else if (document.is(h)) {
                            AbstractLicenseMojo.this.debug("Skipping header file: %s", document.getFile());
                        } else if (document.hasHeader(h, AbstractLicenseMojo.this.strictCheck)) {
                            callback.onExistingHeader(document, h);
                        } else {
                            boolean headerFound = false;
                            for (Header validHeader : validHeaders) {
                                headerFound = document.hasHeader(validHeader, AbstractLicenseMojo.this.strictCheck);
                                if (!headerFound) continue;
                                callback.onExistingHeader(document, h);
                                break;
                            }
                            if (!headerFound) {
                                callback.onHeaderNotFound(document, h);
                            }
                        }
                    }
                }, null);
                ++count;
            }
            while (count-- > 0) {
                try {
                    completionService.take().get();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                catch (ExecutionException e) {
                    Throwable cause = e.getCause();
                    if (cause instanceof Error) {
                        throw (Error)cause;
                    }
                    if (cause instanceof MojoExecutionException) {
                        throw (MojoExecutionException)cause;
                    }
                    if (cause instanceof MojoFailureException) {
                        throw (MojoFailureException)cause;
                    }
                    if (!(cause instanceof RuntimeException)) throw new RuntimeException(cause.getMessage(), cause);
                    throw (RuntimeException)cause;
                    return;
                }
            }
        }
        finally {
            executorService.shutdownNow();
        }
    }

    protected final Map<String, String> mergeProperties() {
        HashMap<String, String> props = new HashMap<String, String>(System.getenv());
        if (this.properties != null) {
            props.putAll(this.properties);
        }
        for (Map.Entry<Object, Object> entry : System.getProperties().entrySet()) {
            props.put(entry.getKey().toString(), entry.getValue().toString());
        }
        return props;
    }

    protected final String[] listSelectedFiles() throws MojoFailureException {
        Selection selection = new Selection(this.basedir, this.includes, this.buildExcludes(), this.useDefaultExcludes);
        this.debug("From: %s", this.basedir);
        this.debug("Including: %s", Arrays.deepToString(selection.getIncluded()));
        this.debug("Excluding: %s", Arrays.deepToString(selection.getExcluded()));
        return selection.getSelectedFiles();
    }

    private String[] buildExcludes() {
        ArrayList<String> ex = new ArrayList<String>();
        ex.addAll(Arrays.asList(this.excludes));
        if (this.project != null && this.project.getModules() != null && !this.aggregate) {
            for (String module : this.project.getModules()) {
                ex.add(module + "/**");
            }
        }
        return ex.toArray(new String[ex.size()]);
    }

    protected final void info(String format, Object ... params) {
        if (!this.quiet) {
            this.getLog().info((CharSequence)String.format(format, params));
        }
    }

    protected final void debug(String format, Object ... params) {
        if (!this.quiet) {
            this.getLog().debug((CharSequence)String.format(format, params));
        }
    }

    protected final void warn(String format, Object ... params) {
        this.getLog().warn((CharSequence)String.format(format, params));
    }

    private Map<String, String> buildMapping() {
        HashMap<String, String> extensionMapping = this.useDefaultMapping ? new HashMap<String, String>(DocumentType.defaultMapping()) : new HashMap();
        for (Map.Entry<String, String> entry : this.mapping.entrySet()) {
            extensionMapping.put(entry.getKey().toLowerCase(), entry.getValue().toLowerCase());
        }
        extensionMapping.put(DocumentType.UNKNOWN.getExtension(), DocumentType.UNKNOWN.getDefaultHeaderTypeName());
        return extensionMapping;
    }

    private Map<String, HeaderDefinition> buildHeaderDefinitions() throws MojoFailureException {
        HashMap<String, HeaderDefinition> headers = new HashMap<String, HeaderDefinition>(HeaderType.defaultDefinitions());
        for (String resource : this.headerDefinitions) {
            AdditionalHeaderDefinition fileDefinitions = new AdditionalHeaderDefinition(XMLDoc.from((URL)this.finder.findResource(resource), (boolean)true));
            Map<String, HeaderDefinition> map = fileDefinitions.getDefinitions();
            this.debug("%d header definitions loaded from '%s'", map.size(), resource);
            headers.putAll(map);
        }
        headers.put(HeaderType.UNKNOWN.getDefinition().getType(), HeaderType.UNKNOWN.getDefinition());
        return headers;
    }
}

