/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.mock.jdbc;

import com.mockrunner.base.NestedApplicationException;
import com.mockrunner.jdbc.AbstractOutParameterResultSetHandler;
import com.mockrunner.mock.jdbc.MockArray;
import com.mockrunner.mock.jdbc.MockBlob;
import com.mockrunner.mock.jdbc.MockClob;
import com.mockrunner.mock.jdbc.MockNClob;
import com.mockrunner.mock.jdbc.MockParameterMap;
import com.mockrunner.mock.jdbc.MockPreparedStatement;
import com.mockrunner.mock.jdbc.MockRef;
import com.mockrunner.mock.jdbc.MockRowId;
import com.mockrunner.mock.jdbc.MockSQLXML;
import com.mockrunner.mock.jdbc.MockUnmodifiableParameterMap;
import com.mockrunner.mock.jdbc.ParameterIndex;
import com.mockrunner.mock.jdbc.ParameterName;
import com.mockrunner.mock.jdbc.ParameterReference;
import com.mockrunner.util.common.StreamUtil;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MockCallableStatement
extends MockPreparedStatement
implements CallableStatement {
    private AbstractOutParameterResultSetHandler resultSetHandler;
    private final Set<ParameterIndex> registeredOutParameterSetIndexed = new HashSet<ParameterIndex>();
    private final Set<ParameterName> registeredOutParameterSetNamed = new HashSet<ParameterName>();
    private List<MockParameterMap> batchParameters = new ArrayList<MockParameterMap>();
    private MockParameterMap lastOutParameters = null;
    private boolean wasNull = false;

    public MockCallableStatement(Connection connection, String sql) {
        super(connection, sql);
    }

    public MockCallableStatement(Connection connection, String sql, int resultSetType, int resultSetConcurrency) {
        super(connection, sql, resultSetType, resultSetConcurrency);
    }

    public MockCallableStatement(Connection connection, String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) {
        super(connection, sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    public void setCallableStatementResultSetHandler(AbstractOutParameterResultSetHandler resultSetHandler) {
        super.setPreparedStatementResultSetHandler(resultSetHandler);
        this.resultSetHandler = resultSetHandler;
    }

    public MockParameterMap getNamedParameterMap() {
        MockParameterMap namedParameters = new MockParameterMap();
        for (ParameterReference parameterReference : this.paramObjects.keySet()) {
            if (!(parameterReference instanceof ParameterName)) continue;
            namedParameters.put(parameterReference, this.paramObjects.get(parameterReference));
        }
        return new MockUnmodifiableParameterMap(namedParameters);
    }

    @Override
    public MockParameterMap getParameterMap() {
        return new MockUnmodifiableParameterMap(this.paramObjects);
    }

    public Object getParameter(String name) {
        return this.paramObjects.get(name);
    }

    @Override
    public void clearParameters() throws SQLException {
        super.clearParameters();
        this.paramObjects.clear();
    }

    public Set<ParameterName> getNamedRegisteredOutParameterSet() {
        return Collections.unmodifiableSet(this.registeredOutParameterSetNamed);
    }

    public boolean isOutParameterRegistered(int index) {
        return this.registeredOutParameterSetIndexed.contains(new ParameterIndex(index));
    }

    public Set<ParameterIndex> getIndexedRegisteredOutParameterSet() {
        return Collections.unmodifiableSet(this.registeredOutParameterSetIndexed);
    }

    public boolean isOutParameterRegistered(String parameterName) {
        return this.registeredOutParameterSetNamed.contains(new ParameterName(parameterName));
    }

    public void clearRegisteredOutParameter() {
        this.registeredOutParameterSetIndexed.clear();
        this.registeredOutParameterSetNamed.clear();
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        ResultSet resultSet = this.executeQuery(this.getParameterMap());
        this.lastOutParameters = this.getOutParameterMap();
        return resultSet;
    }

    @Override
    public int executeUpdate() throws SQLException {
        int updateCount = this.executeUpdate(this.getParameterMap());
        this.lastOutParameters = this.getOutParameterMap();
        return updateCount;
    }

    @Override
    public void addBatch() throws SQLException {
        this.batchParameters.add(new MockParameterMap(this.getParameterMap()));
    }

    @Override
    public int[] executeBatch() throws SQLException {
        return this.executeBatch(this.batchParameters);
    }

    @Override
    public void registerOutParameter(int parameterIndex, int sqlType) throws SQLException {
        this.registeredOutParameterSetIndexed.add(new ParameterIndex(parameterIndex));
    }

    @Override
    public void registerOutParameter(int parameterIndex, int sqlType, int scale) throws SQLException {
        this.registerOutParameter(parameterIndex, sqlType);
    }

    @Override
    public void registerOutParameter(int parameterIndex, int sqlType, String typeName) throws SQLException {
        this.registerOutParameter(parameterIndex, sqlType);
    }

    @Override
    public void registerOutParameter(String parameterName, int sqlType) throws SQLException {
        this.registeredOutParameterSetNamed.add(new ParameterName(parameterName));
    }

    @Override
    public void registerOutParameter(String parameterName, int sqlType, int scale) throws SQLException {
        this.registerOutParameter(parameterName, sqlType);
    }

    @Override
    public void registerOutParameter(String parameterName, int sqlType, String typeName) throws SQLException {
        this.registerOutParameter(parameterName, sqlType);
    }

    @Override
    public boolean wasNull() throws SQLException {
        return this.wasNull;
    }

    @Override
    public Object getObject(int parameterIndex) throws SQLException {
        this.wasNull = false;
        Object returnValue = null;
        if (null != this.lastOutParameters) {
            returnValue = this.lastOutParameters.get(parameterIndex);
        }
        if (null == returnValue) {
            this.wasNull = true;
        }
        return returnValue;
    }

    @Override
    public Object getObject(int parameterIndex, Map<String, Class<?>> map) throws SQLException {
        return this.getObject(parameterIndex);
    }

    @Override
    public <T> T getObject(int parameterIndex, Class<T> type) throws SQLException {
        return (T)this.getObject(parameterIndex);
    }

    @Override
    public <T> T getObject(String parameterName, Class<T> type) throws SQLException {
        return (T)this.getObject(parameterName);
    }

    @Override
    public byte getByte(int parameterIndex) throws SQLException {
        Object value = this.getObject(parameterIndex);
        if (null != value) {
            if (value instanceof Number) {
                return ((Number)value).byteValue();
            }
            return Byte.parseByte(value.toString());
        }
        return 0;
    }

    @Override
    public double getDouble(int parameterIndex) throws SQLException {
        Object value = this.getObject(parameterIndex);
        if (null != value) {
            if (value instanceof Number) {
                return ((Number)value).doubleValue();
            }
            return Double.parseDouble(value.toString());
        }
        return 0.0;
    }

    @Override
    public float getFloat(int parameterIndex) throws SQLException {
        Object value = this.getObject(parameterIndex);
        if (null != value) {
            if (value instanceof Number) {
                return ((Number)value).floatValue();
            }
            return Float.parseFloat(value.toString());
        }
        return 0.0f;
    }

    @Override
    public int getInt(int parameterIndex) throws SQLException {
        Object value = this.getObject(parameterIndex);
        if (null != value) {
            if (value instanceof Number) {
                return ((Number)value).intValue();
            }
            return Integer.parseInt(value.toString());
        }
        return 0;
    }

    @Override
    public long getLong(int parameterIndex) throws SQLException {
        Object value = this.getObject(parameterIndex);
        if (null != value) {
            if (value instanceof Number) {
                return ((Number)value).longValue();
            }
            return Long.parseLong(value.toString());
        }
        return 0L;
    }

    @Override
    public short getShort(int parameterIndex) throws SQLException {
        Object value = this.getObject(parameterIndex);
        if (null != value) {
            if (value instanceof Number) {
                return ((Number)value).shortValue();
            }
            return Short.parseShort(value.toString());
        }
        return 0;
    }

    @Override
    public boolean getBoolean(int parameterIndex) throws SQLException {
        Object value = this.getObject(parameterIndex);
        if (null != value) {
            if (value instanceof Boolean) {
                return (Boolean)value;
            }
            return Boolean.parseBoolean(value.toString());
        }
        return false;
    }

    @Override
    public byte[] getBytes(int parameterIndex) throws SQLException {
        Object value = this.getObject(parameterIndex);
        if (null != value) {
            if (value instanceof byte[]) {
                return (byte[])value;
            }
            try {
                return value.toString().getBytes("ISO-8859-1");
            }
            catch (UnsupportedEncodingException exc) {
                throw new NestedApplicationException((Throwable)exc);
            }
        }
        return null;
    }

    @Override
    public String getString(int parameterIndex) throws SQLException {
        Object value = this.getObject(parameterIndex);
        if (null != value) {
            return value.toString();
        }
        return null;
    }

    @Override
    public String getNString(int parameterIndex) throws SQLException {
        return this.getString(parameterIndex);
    }

    @Override
    public BigDecimal getBigDecimal(int parameterIndex) throws SQLException {
        Object value = this.getObject(parameterIndex);
        if (null != value) {
            if (value instanceof BigDecimal) {
                return (BigDecimal)value;
            }
            if (value instanceof Number) {
                return new BigDecimal(((Number)value).doubleValue());
            }
            return new BigDecimal(value.toString());
        }
        return null;
    }

    @Override
    @Deprecated
    public BigDecimal getBigDecimal(int parameterIndex, int scale) throws SQLException {
        BigDecimal value = this.getBigDecimal(parameterIndex);
        if (null != value) {
            return value.setScale(scale);
        }
        return null;
    }

    @Override
    public URL getURL(int parameterIndex) throws SQLException {
        Object value = this.getObject(parameterIndex);
        if (null != value) {
            if (value instanceof URL) {
                return (URL)value;
            }
            try {
                return new URL(value.toString());
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public Array getArray(int parameterIndex) throws SQLException {
        Object value = this.getObject(parameterIndex);
        if (null != value) {
            if (value instanceof Array) {
                return (Array)value;
            }
            return new MockArray(value);
        }
        return null;
    }

    @Override
    public Blob getBlob(int parameterIndex) throws SQLException {
        Object value = this.getObject(parameterIndex);
        if (null != value) {
            if (value instanceof Blob) {
                return (Blob)value;
            }
            return new MockBlob(this.getBytes(parameterIndex));
        }
        return null;
    }

    @Override
    public Clob getClob(int parameterIndex) throws SQLException {
        Object value = this.getObject(parameterIndex);
        if (null != value) {
            if (value instanceof Clob) {
                return (Clob)value;
            }
            return new MockClob(this.getString(parameterIndex));
        }
        return null;
    }

    @Override
    public NClob getNClob(int parameterIndex) throws SQLException {
        Object value = this.getObject(parameterIndex);
        if (null != value) {
            if (value instanceof NClob) {
                return (NClob)value;
            }
            if (value instanceof Clob) {
                return this.getNClobFromClob((Clob)value);
            }
            return new MockNClob(this.getString(parameterIndex));
        }
        return null;
    }

    @Override
    public SQLXML getSQLXML(int parameterIndex) throws SQLException {
        Object value = this.getObject(parameterIndex);
        if (null != value) {
            if (value instanceof SQLXML) {
                return (SQLXML)value;
            }
            return new MockSQLXML(this.getString(parameterIndex));
        }
        return null;
    }

    @Override
    public Reader getCharacterStream(int parameterIndex) throws SQLException {
        Object value = this.getObject(parameterIndex);
        if (null != value) {
            if (value instanceof Reader) {
                return (Reader)value;
            }
            return new StringReader(this.getString(parameterIndex));
        }
        return null;
    }

    @Override
    public Reader getNCharacterStream(int parameterIndex) throws SQLException {
        return this.getCharacterStream(parameterIndex);
    }

    @Override
    public Date getDate(int parameterIndex) throws SQLException {
        Object value = this.getObject(parameterIndex);
        if (null != value) {
            if (value instanceof Date) {
                return (Date)value;
            }
            return Date.valueOf(value.toString());
        }
        return null;
    }

    @Override
    public Date getDate(int parameterIndex, Calendar calendar) throws SQLException {
        return this.getDate(parameterIndex);
    }

    @Override
    public Ref getRef(int parameterIndex) throws SQLException {
        Object value = this.getObject(parameterIndex);
        if (null != value) {
            if (value instanceof Ref) {
                return (Ref)value;
            }
            return new MockRef(value);
        }
        return null;
    }

    @Override
    public Time getTime(int parameterIndex) throws SQLException {
        Object value = this.getObject(parameterIndex);
        if (null != value) {
            if (value instanceof Time) {
                return (Time)value;
            }
            return Time.valueOf(value.toString());
        }
        return null;
    }

    @Override
    public Time getTime(int parameterIndex, Calendar calendar) throws SQLException {
        return this.getTime(parameterIndex);
    }

    @Override
    public Timestamp getTimestamp(int parameterIndex) throws SQLException {
        Object value = this.getObject(parameterIndex);
        if (null != value) {
            if (value instanceof Timestamp) {
                return (Timestamp)value;
            }
            return Timestamp.valueOf(value.toString());
        }
        return null;
    }

    @Override
    public Timestamp getTimestamp(int parameterIndex, Calendar calendar) throws SQLException {
        return this.getTimestamp(parameterIndex);
    }

    @Override
    public RowId getRowId(int parameterIndex) throws SQLException {
        Object value = this.getObject(parameterIndex);
        if (null != value) {
            if (value instanceof RowId) {
                return (RowId)value;
            }
            return new MockRowId(this.getBytes(parameterIndex));
        }
        return null;
    }

    @Override
    public Object getObject(String parameterName) throws SQLException {
        this.wasNull = false;
        Object returnValue = null;
        if (null != this.lastOutParameters) {
            returnValue = this.lastOutParameters.get(parameterName);
        }
        if (null == returnValue) {
            this.wasNull = true;
        }
        return returnValue;
    }

    @Override
    public Object getObject(String parameterName, Map<String, Class<?>> map) throws SQLException {
        return this.getObject(parameterName);
    }

    @Override
    public byte getByte(String parameterName) throws SQLException {
        Object value = this.getObject(parameterName);
        if (null != value) {
            if (value instanceof Number) {
                return ((Number)value).byteValue();
            }
            return Byte.parseByte(value.toString());
        }
        return 0;
    }

    @Override
    public double getDouble(String parameterName) throws SQLException {
        Object value = this.getObject(parameterName);
        if (null != value) {
            if (value instanceof Number) {
                return ((Number)value).doubleValue();
            }
            return Double.parseDouble(value.toString());
        }
        return 0.0;
    }

    @Override
    public float getFloat(String parameterName) throws SQLException {
        Object value = this.getObject(parameterName);
        if (null != value) {
            if (value instanceof Number) {
                return ((Number)value).floatValue();
            }
            return Float.parseFloat(value.toString());
        }
        return 0.0f;
    }

    @Override
    public int getInt(String parameterName) throws SQLException {
        Object value = this.getObject(parameterName);
        if (null != value) {
            if (value instanceof Number) {
                return ((Number)value).intValue();
            }
            return Integer.parseInt(value.toString());
        }
        return 0;
    }

    @Override
    public long getLong(String parameterName) throws SQLException {
        Object value = this.getObject(parameterName);
        if (null != value) {
            if (value instanceof Number) {
                return ((Number)value).longValue();
            }
            return Long.parseLong(value.toString());
        }
        return 0L;
    }

    @Override
    public short getShort(String parameterName) throws SQLException {
        Object value = this.getObject(parameterName);
        if (null != value) {
            if (value instanceof Number) {
                return ((Number)value).shortValue();
            }
            return Short.parseShort(value.toString());
        }
        return 0;
    }

    @Override
    public boolean getBoolean(String parameterName) throws SQLException {
        Object value = this.getObject(parameterName);
        if (null != value) {
            if (value instanceof Boolean) {
                return (Boolean)value;
            }
            return Boolean.parseBoolean(value.toString());
        }
        return false;
    }

    @Override
    public byte[] getBytes(String parameterName) throws SQLException {
        Object value = this.getObject(parameterName);
        if (null != value) {
            if (value instanceof byte[]) {
                return (byte[])value;
            }
            try {
                return value.toString().getBytes("ISO-8859-1");
            }
            catch (UnsupportedEncodingException exc) {
                throw new NestedApplicationException((Throwable)exc);
            }
        }
        return null;
    }

    @Override
    public String getString(String parameterName) throws SQLException {
        Object value = this.getObject(parameterName);
        if (null != value) {
            return value.toString();
        }
        return null;
    }

    @Override
    public String getNString(String parameterName) throws SQLException {
        return this.getString(parameterName);
    }

    @Override
    public BigDecimal getBigDecimal(String parameterName) throws SQLException {
        Object value = this.getObject(parameterName);
        if (null != value) {
            if (value instanceof BigDecimal) {
                return (BigDecimal)value;
            }
            if (value instanceof Number) {
                return new BigDecimal(((Number)value).doubleValue());
            }
            return new BigDecimal(value.toString());
        }
        return null;
    }

    @Override
    public URL getURL(String parameterName) throws SQLException {
        Object value = this.getObject(parameterName);
        if (null != value) {
            if (value instanceof URL) {
                return (URL)value;
            }
            try {
                return new URL(value.toString());
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public Array getArray(String parameterName) throws SQLException {
        Object value = this.getObject(parameterName);
        if (null != value) {
            if (value instanceof Array) {
                return (Array)value;
            }
            return new MockArray(value);
        }
        return null;
    }

    @Override
    public Blob getBlob(String parameterName) throws SQLException {
        Object value = this.getObject(parameterName);
        if (null != value) {
            if (value instanceof Blob) {
                return (Blob)value;
            }
            return new MockBlob(this.getBytes(parameterName));
        }
        return null;
    }

    @Override
    public Clob getClob(String parameterName) throws SQLException {
        Object value = this.getObject(parameterName);
        if (null != value) {
            if (value instanceof Clob) {
                return (Clob)value;
            }
            return new MockClob(this.getString(parameterName));
        }
        return null;
    }

    @Override
    public NClob getNClob(String parameterName) throws SQLException {
        Object value = this.getObject(parameterName);
        if (null != value) {
            if (value instanceof NClob) {
                return (NClob)value;
            }
            if (value instanceof Clob) {
                return this.getNClobFromClob((Clob)value);
            }
            return new MockNClob(this.getString(parameterName));
        }
        return null;
    }

    @Override
    public SQLXML getSQLXML(String parameterName) throws SQLException {
        Object value = this.getObject(parameterName);
        if (null != value) {
            if (value instanceof SQLXML) {
                return (SQLXML)value;
            }
            return new MockSQLXML(this.getString(parameterName));
        }
        return null;
    }

    @Override
    public Reader getCharacterStream(String parameterName) throws SQLException {
        Object value = this.getObject(parameterName);
        if (null != value) {
            if (value instanceof Reader) {
                return (Reader)value;
            }
            return new StringReader(this.getString(parameterName));
        }
        return null;
    }

    @Override
    public Reader getNCharacterStream(String parameterName) throws SQLException {
        return this.getCharacterStream(parameterName);
    }

    @Override
    public Date getDate(String parameterName) throws SQLException {
        Object value = this.getObject(parameterName);
        if (null != value) {
            if (value instanceof Date) {
                return (Date)value;
            }
            return Date.valueOf(value.toString());
        }
        return null;
    }

    @Override
    public Date getDate(String parameterName, Calendar calendar) throws SQLException {
        return this.getDate(parameterName);
    }

    @Override
    public Ref getRef(String parameterName) throws SQLException {
        Object value = this.getObject(parameterName);
        if (null != value) {
            if (value instanceof Ref) {
                return (Ref)value;
            }
            return new MockRef(value);
        }
        return null;
    }

    @Override
    public Time getTime(String parameterName) throws SQLException {
        Object value = this.getObject(parameterName);
        if (null != value) {
            if (value instanceof Time) {
                return (Time)value;
            }
            return Time.valueOf(value.toString());
        }
        return null;
    }

    @Override
    public Time getTime(String parameterName, Calendar calendar) throws SQLException {
        return this.getTime(parameterName);
    }

    @Override
    public Timestamp getTimestamp(String parameterName) throws SQLException {
        Object value = this.getObject(parameterName);
        if (null != value) {
            if (value instanceof Timestamp) {
                return (Timestamp)value;
            }
            return Timestamp.valueOf(value.toString());
        }
        return null;
    }

    @Override
    public Timestamp getTimestamp(String parameterName, Calendar calendar) throws SQLException {
        return this.getTimestamp(parameterName);
    }

    @Override
    public RowId getRowId(String parameterName) throws SQLException {
        Object value = this.getObject(parameterName);
        if (null != value) {
            if (value instanceof RowId) {
                return (RowId)value;
            }
            return new MockRowId(this.getBytes(parameterName));
        }
        return null;
    }

    @Override
    public void setByte(String parameterName, byte byteValue) throws SQLException {
        this.setObject(parameterName, (Object)byteValue);
    }

    @Override
    public void setDouble(String parameterName, double doubleValue) throws SQLException {
        this.setObject(parameterName, (Object)doubleValue);
    }

    @Override
    public void setFloat(String parameterName, float floatValue) throws SQLException {
        this.setObject(parameterName, (Object)Float.valueOf(floatValue));
    }

    @Override
    public void setInt(String parameterName, int intValue) throws SQLException {
        this.setObject(parameterName, (Object)intValue);
    }

    @Override
    public void setNull(String parameterName, int sqlType) throws SQLException {
        this.setObject(parameterName, null);
    }

    @Override
    public void setNull(String parameterName, int sqlType, String typeName) throws SQLException {
        this.setNull(parameterName, sqlType);
    }

    @Override
    public void setLong(String parameterName, long longValue) throws SQLException {
        this.setObject(parameterName, (Object)longValue);
    }

    @Override
    public void setShort(String parameterName, short shortValue) throws SQLException {
        this.setObject(parameterName, (Object)shortValue);
    }

    @Override
    public void setBoolean(String parameterName, boolean booleanValue) throws SQLException {
        this.setObject(parameterName, (Object)booleanValue);
    }

    @Override
    public void setBytes(String parameterName, byte[] byteArray) throws SQLException {
        this.setObject(parameterName, (Object)byteArray);
    }

    @Override
    public void setAsciiStream(String parameterName, InputStream stream) throws SQLException {
        this.setBinaryStream(parameterName, stream);
    }

    @Override
    public void setAsciiStream(String parameterName, InputStream stream, int length) throws SQLException {
        this.setBinaryStream(parameterName, stream, length);
    }

    @Override
    public void setAsciiStream(String parameterName, InputStream stream, long length) throws SQLException {
        this.setBinaryStream(parameterName, stream, length);
    }

    @Override
    public void setBinaryStream(String parameterName, InputStream stream) throws SQLException {
        byte[] data = StreamUtil.getStreamAsByteArray((InputStream)stream);
        this.setObject(parameterName, (Object)new ByteArrayInputStream(data));
    }

    @Override
    public void setBinaryStream(String parameterName, InputStream stream, int length) throws SQLException {
        byte[] data = StreamUtil.getStreamAsByteArray((InputStream)stream, (int)length);
        this.setObject(parameterName, (Object)new ByteArrayInputStream(data));
    }

    @Override
    public void setBinaryStream(String parameterName, InputStream stream, long length) throws SQLException {
        this.setBinaryStream(parameterName, stream, (int)length);
    }

    @Override
    public void setCharacterStream(String parameterName, Reader reader) throws SQLException {
        String data = StreamUtil.getReaderAsString((Reader)reader);
        this.setObject(parameterName, (Object)new StringReader(data));
    }

    @Override
    public void setCharacterStream(String parameterName, Reader reader, int length) throws SQLException {
        String data = StreamUtil.getReaderAsString((Reader)reader, (int)length);
        this.setObject(parameterName, (Object)new StringReader(data));
    }

    @Override
    public void setCharacterStream(String parameterName, Reader reader, long length) throws SQLException {
        this.setCharacterStream(parameterName, reader, (int)length);
    }

    @Override
    public void setNCharacterStream(String parameterName, Reader reader) throws SQLException {
        this.setCharacterStream(parameterName, reader);
    }

    @Override
    public void setNCharacterStream(String parameterName, Reader reader, long length) throws SQLException {
        this.setCharacterStream(parameterName, reader, length);
    }

    @Override
    public void setBlob(String parameterName, Blob blob) throws SQLException {
        this.setObject(parameterName, (Object)blob);
    }

    @Override
    public void setBlob(String parameterName, InputStream inputStream) throws SQLException {
        byte[] data = StreamUtil.getStreamAsByteArray((InputStream)inputStream);
        this.setBlob(parameterName, (Blob)new MockBlob(data));
    }

    @Override
    public void setBlob(String parameterName, InputStream inputStream, long length) throws SQLException {
        byte[] data = StreamUtil.getStreamAsByteArray((InputStream)inputStream, (int)((int)length));
        this.setBlob(parameterName, (Blob)new MockBlob(data));
    }

    @Override
    public void setClob(String parameterName, Clob clob) throws SQLException {
        this.setObject(parameterName, (Object)clob);
    }

    @Override
    public void setClob(String parameterName, Reader reader) throws SQLException {
        String data = StreamUtil.getReaderAsString((Reader)reader);
        this.setClob(parameterName, (Clob)new MockClob(data));
    }

    @Override
    public void setClob(String parameterName, Reader reader, long length) throws SQLException {
        String data = StreamUtil.getReaderAsString((Reader)reader, (int)((int)length));
        this.setClob(parameterName, (Clob)new MockClob(data));
    }

    @Override
    public void setNClob(String parameterName, NClob nClob) throws SQLException {
        this.setObject(parameterName, (Object)nClob);
    }

    @Override
    public void setNClob(String parameterName, Reader reader) throws SQLException {
        String data = StreamUtil.getReaderAsString((Reader)reader);
        this.setNClob(parameterName, (NClob)new MockNClob(data));
    }

    @Override
    public void setNClob(String parameterName, Reader reader, long length) throws SQLException {
        String data = StreamUtil.getReaderAsString((Reader)reader, (int)((int)length));
        this.setNClob(parameterName, (NClob)new MockNClob(data));
    }

    @Override
    public void setSQLXML(String parameterName, SQLXML xmlObject) throws SQLException {
        this.setObject(parameterName, (Object)xmlObject);
    }

    @Override
    public void setString(String parameterName, String string) throws SQLException {
        this.setObject(parameterName, (Object)string);
    }

    @Override
    public void setNString(String parameterName, String string) throws SQLException {
        this.setObject(parameterName, (Object)string);
    }

    @Override
    public void setBigDecimal(String parameterName, BigDecimal bigDecimal) throws SQLException {
        this.setObject(parameterName, (Object)bigDecimal);
    }

    @Override
    public void setURL(String parameterName, URL url) throws SQLException {
        this.setObject(parameterName, (Object)url);
    }

    @Override
    public void setDate(String parameterName, Date date) throws SQLException {
        this.setObject(parameterName, (Object)date);
    }

    @Override
    public void setTime(String parameterName, Time time) throws SQLException {
        this.setObject(parameterName, (Object)time);
    }

    @Override
    public void setTimestamp(String parameterName, Timestamp timestamp) throws SQLException {
        this.setObject(parameterName, (Object)timestamp);
    }

    @Override
    public void setDate(String parameterName, Date date, Calendar calendar) throws SQLException {
        this.setDate(parameterName, date);
    }

    @Override
    public void setTime(String parameterName, Time time, Calendar calendar) throws SQLException {
        this.setTime(parameterName, time);
    }

    @Override
    public void setTimestamp(String parameterName, Timestamp timestamp, Calendar calendar) throws SQLException {
        this.setTimestamp(parameterName, timestamp);
    }

    @Override
    public void setRowId(String parameterName, RowId rowId) throws SQLException {
        this.setObject(parameterName, (Object)rowId);
    }

    @Override
    public void setObject(String parameterName, Object object) throws SQLException {
        this.paramObjects.put(parameterName, object);
    }

    @Override
    public void setObject(String parameterName, Object object, int targetSqlType) throws SQLException {
        this.setObject(parameterName, object);
    }

    @Override
    public void setObject(String parameterName, Object object, int targetSqlType, int scale) throws SQLException {
        this.setObject(parameterName, object);
    }

    private MockParameterMap getOutParameterMap() {
        MockParameterMap outParameter = this.resultSetHandler.getOutParameter(this.getSQL(), this.getParameterMap());
        if (null == outParameter) {
            outParameter = this.resultSetHandler.getOutParameter(this.getSQL());
        }
        if (null == outParameter) {
            outParameter = this.resultSetHandler.getGlobalOutParameter();
        }
        if (this.resultSetHandler.getMustRegisterOutParameters()) {
            return this.filterNotRegisteredParameters(outParameter);
        }
        return outParameter;
    }

    private MockParameterMap filterNotRegisteredParameters(MockParameterMap outParameter) {
        MockParameterMap filteredMap = new MockParameterMap();
        for (ParameterReference nextKey : outParameter.keySet()) {
            if (!this.registeredOutParameterSetIndexed.contains(nextKey) && !this.registeredOutParameterSetNamed.contains(nextKey)) continue;
            filteredMap.put(nextKey, outParameter.get(nextKey));
        }
        return new MockUnmodifiableParameterMap(filteredMap);
    }

    private NClob getNClobFromClob(Clob clobValue) throws SQLException {
        return new MockNClob(clobValue.getSubString(1L, (int)clobValue.length()));
    }
}

