/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.mock.jdbc;

import com.mockrunner.base.NestedApplicationException;
import com.mockrunner.jdbc.AbstractResultSetHandler;
import com.mockrunner.jdbc.SQLUtil;
import com.mockrunner.mock.jdbc.MockResultSet;
import com.mockrunner.util.common.ArrayUtil;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

public class MockStatement
implements Statement {
    private AbstractResultSetHandler resultSetHandler;
    private ResultSet[] currentResultSets = null;
    private int[] currentUpdateCounts = null;
    private int currentResultSetIndex = 0;
    private int currentUpdateCountIndex = 0;
    private List batches = new ArrayList();
    private String cursorName = "";
    private int querySeconds = 0;
    private int maxRows = 0;
    private int maxFieldSize = 0;
    private int fetchDirection = 1000;
    private int fetchSize = 0;
    private int resultSetType = 1003;
    private int resultSetConcurrency = 1007;
    private int resultSetHoldability = 1;
    private MockResultSet lastGeneratedKeys = null;
    private boolean closed = false;
    private boolean poolable = false;
    private boolean closeOnCompletition = false;
    private Connection connection;

    public MockStatement(Connection connection) {
        this.connection = connection;
        this.resultSetType = 1003;
        this.resultSetConcurrency = 1007;
        try {
            this.resultSetHoldability = connection.getMetaData().getResultSetHoldability();
        }
        catch (SQLException exc) {
            throw new NestedApplicationException((Throwable)exc);
        }
    }

    public MockStatement(Connection connection, int resultSetType, int resultSetConcurrency) {
        this.connection = connection;
        this.resultSetType = resultSetType;
        this.resultSetConcurrency = resultSetConcurrency;
        try {
            this.resultSetHoldability = connection.getMetaData().getResultSetHoldability();
        }
        catch (SQLException exc) {
            throw new NestedApplicationException((Throwable)exc);
        }
    }

    public MockStatement(Connection connection, int resultSetType, int resultSetConcurrency, int resultSetHoldability) {
        this.connection = connection;
        this.resultSetType = resultSetType;
        this.resultSetConcurrency = resultSetConcurrency;
        this.resultSetHoldability = resultSetHoldability;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void setResultSetHandler(AbstractResultSetHandler resultSetHandler) {
        this.resultSetHandler = resultSetHandler;
    }

    protected void setResultSets(ResultSet[] resultSets) {
        this.closeCurrentResultSets();
        this.currentUpdateCounts = null;
        this.currentResultSets = resultSets;
        this.currentResultSetIndex = 0;
        this.currentUpdateCountIndex = 0;
    }

    protected void setUpdateCounts(int[] updateCounts) {
        this.closeCurrentResultSets();
        this.currentResultSets = null;
        this.currentUpdateCounts = updateCounts;
        this.currentResultSetIndex = 0;
        this.currentUpdateCountIndex = 0;
    }

    public String getCursorName() {
        return this.cursorName;
    }

    public ResultSet executeQuery(String sql) throws SQLException {
        SQLException exception = this.resultSetHandler.getSQLException(sql);
        if (null != exception) {
            throw exception;
        }
        this.resultSetHandler.addExecutedStatement(sql);
        if (this.resultSetHandler.hasMultipleResultSets(sql)) {
            MockResultSet[] results = this.resultSetHandler.getResultSets(sql);
            if (null != results) {
                return this.cloneAndSetMultipleResultSets(results);
            }
        } else {
            MockResultSet result = this.resultSetHandler.getResultSet(sql);
            if (null != result) {
                return this.cloneAndSetSingleResultSet(result);
            }
        }
        if (this.resultSetHandler.hasMultipleGlobalResultSets()) {
            return this.cloneAndSetMultipleResultSets(this.resultSetHandler.getGlobalResultSets());
        }
        return this.cloneAndSetSingleResultSet(this.resultSetHandler.getGlobalResultSet());
    }

    private MockResultSet cloneAndSetSingleResultSet(MockResultSet result) {
        if (null != (result = this.cloneResultSet(result))) {
            this.resultSetHandler.addReturnedResultSet(result);
        }
        this.setResultSets(new MockResultSet[]{result});
        this.setLastGeneratedKeysResultSet(null);
        return result;
    }

    private MockResultSet cloneAndSetMultipleResultSets(MockResultSet[] results) {
        if (null != (results = this.cloneResultSets(results))) {
            this.resultSetHandler.addReturnedResultSets(results);
        }
        this.setResultSets(results);
        this.setLastGeneratedKeysResultSet(null);
        if (null != results && results.length > 0) {
            return results[0];
        }
        return null;
    }

    private void closeCurrentResultSets() {
        if (null != this.currentResultSets) {
            for (int ii = 0; ii < this.currentResultSets.length; ++ii) {
                try {
                    if (null == this.currentResultSets[ii]) continue;
                    this.currentResultSets[ii].close();
                    continue;
                }
                catch (SQLException exc) {
                    throw new NestedApplicationException((Throwable)exc);
                }
            }
        }
    }

    public int executeUpdate(String sql) throws SQLException {
        SQLException exception = this.resultSetHandler.getSQLException(sql);
        if (null != exception) {
            throw exception;
        }
        this.resultSetHandler.addExecutedStatement(sql);
        if (this.resultSetHandler.hasMultipleUpdateCounts(sql)) {
            Object[] returnValues = this.resultSetHandler.getUpdateCounts(sql);
            if (null != returnValues) {
                return this.setMultipleUpdateCounts((int[])ArrayUtil.convertToPrimitiveArray((Object[])returnValues));
            }
        } else {
            Integer returnValue = this.resultSetHandler.getUpdateCount(sql);
            if (null != returnValue) {
                return this.setSingleUpdateCount(returnValue);
            }
        }
        if (this.resultSetHandler.hasMultipleGlobalUpdateCounts()) {
            return this.setMultipleUpdateCounts(this.resultSetHandler.getGlobalUpdateCounts());
        }
        return this.setSingleUpdateCount(this.resultSetHandler.getGlobalUpdateCount());
    }

    private int setSingleUpdateCount(int updateCount) {
        this.setUpdateCounts(new int[]{updateCount});
        this.setLastGeneratedKeysResultSet(null);
        return updateCount;
    }

    private int setMultipleUpdateCounts(int[] updateCounts) {
        this.setUpdateCounts(updateCounts);
        this.setLastGeneratedKeysResultSet(null);
        if (null != updateCounts && updateCounts.length > 0) {
            return updateCounts[0];
        }
        return 0;
    }

    public boolean execute(String sql) throws SQLException {
        boolean callExecuteQuery = this.isQuery(sql);
        if (callExecuteQuery) {
            this.executeQuery(sql);
        } else {
            this.executeUpdate(sql);
        }
        return callExecuteQuery;
    }

    public int[] executeBatch() throws SQLException {
        int[] results = new int[this.batches.size()];
        Throwable exception = null;
        for (int ii = 0; ii < results.length; ++ii) {
            String nextSQL = (String)this.batches.get(ii);
            if (this.isQuery(nextSQL)) {
                exception = this.prepareFailedResult(results, ii, "SQL " + this.batches.get(ii) + " in the list of batches returned a ResultSet.", null);
            } else {
                try {
                    results[ii] = this.executeUpdate(nextSQL);
                }
                catch (SQLException exc) {
                    exception = this.prepareFailedResult(results, ii, null, exc);
                }
            }
            if (null == exception || this.resultSetHandler.getContinueProcessingOnBatchFailure()) continue;
            throw exception;
        }
        if (null != exception) {
            throw new BatchUpdateException(exception.getMessage(), ((SQLException)exception).getSQLState(), ((SQLException)exception).getErrorCode(), results);
        }
        return results;
    }

    protected SQLException prepareFailedResult(int[] actualResults, int index, String message, SQLException caughtException) {
        actualResults[index] = -3;
        if (caughtException instanceof BatchUpdateException) {
            return caughtException;
        }
        int[] partialResults = (int[])ArrayUtil.truncateArray((Object)actualResults, (int)index);
        if (null == caughtException) {
            return new BatchUpdateException(message, partialResults);
        }
        return new BatchUpdateException(caughtException.getMessage(), caughtException.getSQLState(), caughtException.getErrorCode(), partialResults);
    }

    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        int updateCount = this.executeUpdate(sql);
        this.setGeneratedKeysResultSet(sql, autoGeneratedKeys);
        return updateCount;
    }

    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        return this.executeUpdate(sql, 1);
    }

    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        return this.executeUpdate(sql, 1);
    }

    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        boolean isQuery = this.execute(sql);
        this.setGeneratedKeysResultSet(sql, autoGeneratedKeys);
        return isQuery;
    }

    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        return this.execute(sql, 1);
    }

    public boolean execute(String sql, String[] columnNames) throws SQLException {
        return this.execute(sql, 1);
    }

    private void setGeneratedKeysResultSet(String sql, int autoGeneratedKeys) throws SQLException {
        if (1 != autoGeneratedKeys && 2 != autoGeneratedKeys) {
            throw new SQLException("autoGeneratedKeys must be either Statement.RETURN_GENERATED_KEYS or Statement.NO_GENERATED_KEYS");
        }
        if (1 == autoGeneratedKeys) {
            this.setLastGeneratedKeysResultSet(this.determineGeneratedKeysResultSet(sql));
        } else {
            this.setLastGeneratedKeysResultSet(null);
        }
    }

    protected void setLastGeneratedKeysResultSet(MockResultSet generatedKeys) {
        this.lastGeneratedKeys = generatedKeys;
    }

    protected MockResultSet determineGeneratedKeysResultSet(String sql) {
        MockResultSet generatedKeys = this.resultSetHandler.getGeneratedKeys(sql);
        if (null != generatedKeys) {
            return generatedKeys;
        }
        return this.resultSetHandler.getGlobalGeneratedKeys();
    }

    public void close() throws SQLException {
        this.closed = true;
    }

    public int getMaxFieldSize() throws SQLException {
        return this.maxFieldSize;
    }

    public void setMaxFieldSize(int maxFieldSize) throws SQLException {
        this.maxFieldSize = maxFieldSize;
    }

    public int getMaxRows() throws SQLException {
        return this.maxRows;
    }

    public void setMaxRows(int maxRows) throws SQLException {
        this.maxRows = maxRows;
    }

    public void setEscapeProcessing(boolean enable) throws SQLException {
    }

    public int getQueryTimeout() throws SQLException {
        return this.querySeconds;
    }

    public void setQueryTimeout(int querySeconds) throws SQLException {
        this.querySeconds = querySeconds;
    }

    public void cancel() throws SQLException {
    }

    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    public void clearWarnings() throws SQLException {
    }

    public void setCursorName(String cursorName) throws SQLException {
        this.cursorName = cursorName;
    }

    protected boolean isQuery(String sql) {
        Boolean returnsResultSet = this.resultSetHandler.getReturnsResultSet(sql);
        boolean isQuery = null != returnsResultSet ? returnsResultSet : SQLUtil.isSelect(sql);
        return isQuery;
    }

    public ResultSet getResultSet() throws SQLException {
        if (null == this.currentResultSets) {
            return null;
        }
        if (this.currentResultSetIndex >= this.currentResultSets.length) {
            return null;
        }
        return this.currentResultSets[this.currentResultSetIndex];
    }

    public int getUpdateCount() throws SQLException {
        if (null == this.currentUpdateCounts) {
            return -1;
        }
        if (this.currentUpdateCountIndex >= this.currentUpdateCounts.length) {
            return -1;
        }
        return this.currentUpdateCounts[this.currentUpdateCountIndex];
    }

    public boolean getMoreResults(int current) throws SQLException {
        return this.getMoreResults(current != 2);
    }

    public boolean getMoreResults() throws SQLException {
        return this.getMoreResults(true);
    }

    private boolean getMoreResults(boolean doCloseCurrentResult) throws SQLException {
        if (null != this.currentResultSets) {
            if (this.currentResultSetIndex < this.currentResultSets.length) {
                if (null != this.currentResultSets[this.currentResultSetIndex] && doCloseCurrentResult) {
                    this.currentResultSets[this.currentResultSetIndex].close();
                }
                ++this.currentResultSetIndex;
            }
            return this.currentResultSetIndex < this.currentResultSets.length;
        }
        if (null != this.currentUpdateCounts && this.currentUpdateCountIndex < this.currentUpdateCounts.length) {
            ++this.currentUpdateCountIndex;
        }
        return false;
    }

    public void setFetchDirection(int fetchDirection) throws SQLException {
        this.fetchDirection = fetchDirection;
    }

    public int getFetchDirection() throws SQLException {
        return this.fetchDirection;
    }

    public void setFetchSize(int fetchSize) throws SQLException {
        this.fetchSize = fetchSize;
    }

    public int getFetchSize() throws SQLException {
        return this.fetchSize;
    }

    public void addBatch(String sql) throws SQLException {
        this.batches.add(sql);
    }

    public void clearBatch() throws SQLException {
        this.batches.clear();
    }

    public Connection getConnection() throws SQLException {
        return this.connection;
    }

    public ResultSet getGeneratedKeys() throws SQLException {
        if (null == this.lastGeneratedKeys) {
            MockResultSet resultSet = new MockResultSet("Last statement did not generate any keys");
            resultSet.setStatement(this);
            return resultSet;
        }
        return this.cloneResultSet(this.lastGeneratedKeys);
    }

    public int getResultSetType() throws SQLException {
        return this.resultSetType;
    }

    public int getResultSetConcurrency() throws SQLException {
        return this.resultSetConcurrency;
    }

    public int getResultSetHoldability() throws SQLException {
        return this.resultSetHoldability;
    }

    public boolean isPoolable() throws SQLException {
        return this.poolable;
    }

    public void setPoolable(boolean poolable) throws SQLException {
        this.poolable = poolable;
    }

    public boolean isWrapperFor(Class iface) throws SQLException {
        return false;
    }

    public Object unwrap(Class iface) throws SQLException {
        throw new SQLException("No object found for " + iface);
    }

    public void closeOnCompletion() throws SQLException {
        this.closeOnCompletition = true;
    }

    public boolean isCloseOnCompletion() throws SQLException {
        return this.closeOnCompletition;
    }

    protected MockResultSet cloneResultSet(MockResultSet resultSet) {
        if (null == resultSet) {
            return null;
        }
        MockResultSet clone = (MockResultSet)resultSet.clone();
        clone.setStatement(this);
        return clone;
    }

    protected MockResultSet[] cloneResultSets(MockResultSet[] resultSets) {
        if (null == resultSets) {
            return null;
        }
        MockResultSet[] clonedResultsSets = new MockResultSet[resultSets.length];
        for (int ii = 0; ii < resultSets.length; ++ii) {
            if (null == resultSets[ii]) continue;
            clonedResultsSets[ii] = (MockResultSet)resultSets[ii].clone();
            clonedResultsSets[ii].setStatement(this);
        }
        return clonedResultsSets;
    }
}

