/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.mock.jdbc;

import com.mockrunner.jdbc.AbstractParameterResultSetHandler;
import com.mockrunner.jdbc.ParameterUtil;
import com.mockrunner.mock.jdbc.MockBlob;
import com.mockrunner.mock.jdbc.MockClob;
import com.mockrunner.mock.jdbc.MockNClob;
import com.mockrunner.mock.jdbc.MockParameterMetaData;
import com.mockrunner.mock.jdbc.MockResultSet;
import com.mockrunner.mock.jdbc.MockResultSetMetaData;
import com.mockrunner.mock.jdbc.MockStatement;
import com.mockrunner.util.common.ArrayUtil;
import com.mockrunner.util.common.StreamUtil;
import com.mockrunner.util.common.StringUtil;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.BatchUpdateException;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MockPreparedStatement
extends MockStatement
implements PreparedStatement {
    private AbstractParameterResultSetHandler resultSetHandler;
    private Map paramObjects = new HashMap();
    private List batchParameters = new ArrayList();
    private String sql;
    private MockParameterMetaData parameterMetaData;
    private boolean returnGeneratedKeys = false;

    public MockPreparedStatement(Connection connection, String sql) {
        this(connection, sql, false);
    }

    public MockPreparedStatement(Connection connection, String sql, boolean returnGeneratedKeys) {
        super(connection);
        this.sql = sql;
        this.returnGeneratedKeys = returnGeneratedKeys;
        this.prepareParameterMetaData();
    }

    public MockPreparedStatement(Connection connection, String sql, int resultSetType, int resultSetConcurrency) {
        super(connection, resultSetType, resultSetConcurrency);
        this.sql = sql;
        this.prepareParameterMetaData();
    }

    public MockPreparedStatement(Connection connection, String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) {
        super(connection, resultSetType, resultSetConcurrency, resultSetHoldability);
        this.sql = sql;
        this.prepareParameterMetaData();
    }

    public void setPreparedStatementResultSetHandler(AbstractParameterResultSetHandler resultSetHandler) {
        super.setResultSetHandler(resultSetHandler);
        this.resultSetHandler = resultSetHandler;
    }

    private void prepareParameterMetaData() {
        int number = StringUtil.countMatches((String)this.sql, (String)"?");
        this.parameterMetaData = new MockParameterMetaData();
        this.parameterMetaData.setParameterCount(number);
    }

    public String getSQL() {
        return this.sql;
    }

    public Map getIndexedParameterMap() {
        return Collections.unmodifiableMap(this.paramObjects);
    }

    public Map getParameterMap() {
        return this.getIndexedParameterMap();
    }

    public Object getParameter(int index) {
        return this.paramObjects.get(new Integer(index));
    }

    public void setObject(int index, Object object) throws SQLException {
        this.paramObjects.put(new Integer(index), object);
    }

    public void setObject(int parameterIndex, Object object, int targetSqlType, int scale) throws SQLException {
        this.setObject(parameterIndex, object);
    }

    public void setObject(int parameterIndex, Object object, int targetSqlType) throws SQLException {
        this.setObject(parameterIndex, object);
    }

    public void addBatch() throws SQLException {
        this.batchParameters.add(new HashMap(this.paramObjects));
    }

    public void clearBatch() throws SQLException {
        super.clearBatch();
        this.batchParameters.clear();
    }

    public void clearParameters() throws SQLException {
        this.paramObjects.clear();
    }

    public boolean execute() throws SQLException {
        boolean callExecuteQuery = this.isQuery(this.getSQL());
        if (callExecuteQuery) {
            this.executeQuery();
        } else {
            this.executeUpdate();
        }
        return callExecuteQuery;
    }

    public ResultSet executeQuery() throws SQLException {
        return this.executeQuery(this.paramObjects);
    }

    protected ResultSet executeQuery(Map params) throws SQLException {
        SQLException exception = this.resultSetHandler.getSQLException(this.sql, params);
        if (null != exception) {
            throw exception;
        }
        exception = this.resultSetHandler.getSQLException(this.sql);
        if (null != exception) {
            throw exception;
        }
        this.resultSetHandler.addParameterMapForExecutedStatement(this.getSQL(), this.getParameterMapCopy(params));
        if (this.resultSetHandler.hasMultipleResultSets(this.getSQL(), params)) {
            MockResultSet[] results = this.resultSetHandler.getResultSets(this.getSQL(), params);
            if (null != results) {
                this.resultSetHandler.addExecutedStatement(this.getSQL());
                return this.cloneAndSetMultipleResultSets(results, params);
            }
        } else {
            MockResultSet result = this.resultSetHandler.getResultSet(this.getSQL(), params);
            if (null == result) {
                return new MockResultSet(String.valueOf(Math.random()));
            }
            this.resultSetHandler.addExecutedStatement(this.getSQL());
            return this.cloneAndSetSingleResultSet(result, params);
        }
        ResultSet superResultSet = super.executeQuery(this.getSQL());
        this.setGeneratedKeysResultSet(this.sql, params);
        return superResultSet;
    }

    private MockResultSet cloneAndSetSingleResultSet(MockResultSet result, Map params) {
        if (null != (result = this.cloneResultSet(result))) {
            this.resultSetHandler.addReturnedResultSet(result);
        }
        this.setResultSets(new MockResultSet[]{result});
        this.setGeneratedKeysResultSet(this.sql, params);
        return result;
    }

    private MockResultSet cloneAndSetMultipleResultSets(MockResultSet[] results, Map params) {
        if (null != (results = this.cloneResultSets(results))) {
            this.resultSetHandler.addReturnedResultSets(results);
        }
        this.setResultSets(results);
        this.setGeneratedKeysResultSet(this.sql, params);
        if (null != results && results.length > 0) {
            return results[0];
        }
        return null;
    }

    public int executeUpdate() throws SQLException {
        return this.executeUpdate(this.paramObjects);
    }

    protected int executeUpdate(Map params) throws SQLException {
        SQLException exception = this.resultSetHandler.getSQLException(this.sql, params);
        if (null != exception) {
            throw exception;
        }
        exception = this.resultSetHandler.getSQLException(this.sql);
        if (null != exception) {
            throw exception;
        }
        this.resultSetHandler.addParameterMapForExecutedStatement(this.getSQL(), this.getParameterMapCopy(params));
        if (this.resultSetHandler.hasMultipleUpdateCounts(this.getSQL(), params)) {
            Object[] updateCounts = this.resultSetHandler.getUpdateCounts(this.getSQL(), params);
            if (null != updateCounts) {
                this.resultSetHandler.addExecutedStatement(this.getSQL());
                return this.setMultipleUpdateCounts((int[])ArrayUtil.convertToPrimitiveArray((Object[])updateCounts), params);
            }
        } else {
            Integer updateCount = this.resultSetHandler.getUpdateCount(this.getSQL(), params);
            if (null != updateCount) {
                this.resultSetHandler.addExecutedStatement(this.getSQL());
                return this.setSingleUpdateCount(updateCount, params);
            }
        }
        int superUpdateCount = super.executeUpdate(this.getSQL());
        this.setGeneratedKeysResultSet(this.sql, params);
        return superUpdateCount;
    }

    private int setSingleUpdateCount(int updateCount, Map params) {
        this.setUpdateCounts(new int[]{updateCount});
        this.setGeneratedKeysResultSet(this.sql, params);
        return updateCount;
    }

    private int setMultipleUpdateCounts(int[] updateCounts, Map params) {
        this.setUpdateCounts(updateCounts);
        this.setGeneratedKeysResultSet(this.sql, params);
        if (null != updateCounts && updateCounts.length > 0) {
            return updateCounts[0];
        }
        return 0;
    }

    public int[] executeBatch() throws SQLException {
        return this.executeBatch(this.batchParameters);
    }

    protected int[] executeBatch(List batchParams) throws SQLException {
        int[] results = new int[batchParams.size()];
        Throwable exception = null;
        for (int ii = 0; ii < results.length; ++ii) {
            if (this.isQuery(this.getSQL())) {
                exception = this.prepareFailedResult(results, ii, "SQL " + this.getSQL() + " in the list of batches returned a ResultSet.", null);
            } else {
                try {
                    Map currentParameters = (Map)batchParams.get(ii);
                    results[ii] = this.executeUpdate(currentParameters);
                }
                catch (SQLException exc) {
                    exception = this.prepareFailedResult(results, ii, null, exc);
                }
            }
            if (null == exception || this.resultSetHandler.getContinueProcessingOnBatchFailure()) continue;
            throw exception;
        }
        if (null != exception) {
            throw new BatchUpdateException(exception.getMessage(), ((SQLException)exception).getSQLState(), ((SQLException)exception).getErrorCode(), results);
        }
        return results;
    }

    private void setGeneratedKeysResultSet(String sql, Map params) {
        MockResultSet generatedKeys = this.resultSetHandler.getGeneratedKeys(sql, params);
        if (this.returnGeneratedKeys) {
            if (null != generatedKeys) {
                this.setLastGeneratedKeysResultSet(generatedKeys);
            } else {
                this.setLastGeneratedKeysResultSet(this.determineGeneratedKeysResultSet(sql));
            }
        } else {
            this.setLastGeneratedKeysResultSet(null);
        }
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        return new MockResultSetMetaData();
    }

    public ParameterMetaData getParameterMetaData() throws SQLException {
        return this.parameterMetaData;
    }

    public void setArray(int parameterIndex, Array array) throws SQLException {
        this.setObject(parameterIndex, array);
    }

    public void setAsciiStream(int parameterIndex, InputStream stream) throws SQLException {
        this.setBinaryStream(parameterIndex, stream);
    }

    public void setAsciiStream(int parameterIndex, InputStream stream, int length) throws SQLException {
        this.setBinaryStream(parameterIndex, stream, length);
    }

    public void setAsciiStream(int parameterIndex, InputStream stream, long length) throws SQLException {
        this.setBinaryStream(parameterIndex, stream, length);
    }

    public void setBinaryStream(int parameterIndex, InputStream stream) throws SQLException {
        byte[] data = StreamUtil.getStreamAsByteArray((InputStream)stream);
        this.setObject(parameterIndex, new ByteArrayInputStream(data));
    }

    public void setBinaryStream(int parameterIndex, InputStream stream, int length) throws SQLException {
        byte[] data = StreamUtil.getStreamAsByteArray((InputStream)stream, (int)length);
        this.setObject(parameterIndex, new ByteArrayInputStream(data));
    }

    public void setBinaryStream(int parameterIndex, InputStream stream, long length) throws SQLException {
        this.setBinaryStream(parameterIndex, stream, (int)length);
    }

    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        String data = StreamUtil.getReaderAsString((Reader)reader);
        this.setObject(parameterIndex, new StringReader(data));
    }

    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        String data = StreamUtil.getReaderAsString((Reader)reader, (int)length);
        this.setObject(parameterIndex, new StringReader(data));
    }

    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        this.setCharacterStream(parameterIndex, reader, (int)length);
    }

    public void setNCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        this.setCharacterStream(parameterIndex, reader);
    }

    public void setNCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        this.setCharacterStream(parameterIndex, reader, length);
    }

    public void setBigDecimal(int parameterIndex, BigDecimal bigDecimal) throws SQLException {
        this.setObject(parameterIndex, bigDecimal);
    }

    public void setBlob(int parameterIndex, Blob blob) throws SQLException {
        this.setObject(parameterIndex, blob);
    }

    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        byte[] data = StreamUtil.getStreamAsByteArray((InputStream)inputStream);
        this.setBlob(parameterIndex, new MockBlob(data));
    }

    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        byte[] data = StreamUtil.getStreamAsByteArray((InputStream)inputStream, (int)((int)length));
        this.setBlob(parameterIndex, new MockBlob(data));
    }

    public void setBoolean(int parameterIndex, boolean bool) throws SQLException {
        this.setObject(parameterIndex, new Boolean(bool));
    }

    public void setByte(int parameterIndex, byte byteValue) throws SQLException {
        this.setObject(parameterIndex, new Byte(byteValue));
    }

    public void setBytes(int parameterIndex, byte[] byteArray) throws SQLException {
        this.setObject(parameterIndex, byteArray);
    }

    public void setClob(int parameterIndex, Clob clob) throws SQLException {
        this.setObject(parameterIndex, clob);
    }

    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        String data = StreamUtil.getReaderAsString((Reader)reader);
        this.setClob(parameterIndex, new MockClob(data));
    }

    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        String data = StreamUtil.getReaderAsString((Reader)reader, (int)((int)length));
        this.setClob(parameterIndex, new MockClob(data));
    }

    public void setNClob(int parameterIndex, NClob nClob) throws SQLException {
        this.setObject(parameterIndex, nClob);
    }

    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        String data = StreamUtil.getReaderAsString((Reader)reader);
        this.setNClob(parameterIndex, new MockNClob(data));
    }

    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        String data = StreamUtil.getReaderAsString((Reader)reader, (int)((int)length));
        this.setNClob(parameterIndex, new MockNClob(data));
    }

    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        this.setObject(parameterIndex, xmlObject);
    }

    public void setDate(int parameterIndex, Date date, Calendar calendar) throws SQLException {
        this.setObject(parameterIndex, date);
    }

    public void setDate(int parameterIndex, Date date) throws SQLException {
        this.setObject(parameterIndex, date);
    }

    public void setDouble(int parameterIndex, double doubleValue) throws SQLException {
        this.setObject(parameterIndex, new Double(doubleValue));
    }

    public void setFloat(int parameterIndex, float floatValue) throws SQLException {
        this.setObject(parameterIndex, new Float(floatValue));
    }

    public void setInt(int parameterIndex, int intValue) throws SQLException {
        this.setObject(parameterIndex, new Integer(intValue));
    }

    public void setLong(int parameterIndex, long longValue) throws SQLException {
        this.setObject(parameterIndex, new Long(longValue));
    }

    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        this.setObject(parameterIndex, null);
    }

    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.setObject(parameterIndex, null);
    }

    public void setRef(int parameterIndex, Ref ref) throws SQLException {
        this.setObject(parameterIndex, ref);
    }

    public void setRowId(int parameterIndex, RowId rowId) throws SQLException {
        this.setObject(parameterIndex, rowId);
    }

    public void setShort(int parameterIndex, short shortValue) throws SQLException {
        this.setObject(parameterIndex, new Short(shortValue));
    }

    public void setString(int parameterIndex, String string) throws SQLException {
        this.setObject(parameterIndex, string);
    }

    public void setNString(int parameterIndex, String string) throws SQLException {
        this.setObject(parameterIndex, string);
    }

    public void setTime(int parameterIndex, Time time, Calendar calendar) throws SQLException {
        this.setObject(parameterIndex, time);
    }

    public void setTime(int parameterIndex, Time time) throws SQLException {
        this.setObject(parameterIndex, time);
    }

    public void setTimestamp(int parameterIndex, Timestamp timeStamp, Calendar cal) throws SQLException {
        this.setObject(parameterIndex, timeStamp);
    }

    public void setTimestamp(int parameterIndex, Timestamp timeStamp) throws SQLException {
        this.setObject(parameterIndex, timeStamp);
    }

    public void setUnicodeStream(int parameterIndex, InputStream stream, int length) throws SQLException {
        this.setObject(parameterIndex, stream);
    }

    public void setURL(int parameterIndex, URL url) throws SQLException {
        this.setObject(parameterIndex, url);
    }

    private Map getParameterMapCopy(Map actualParameters) {
        HashMap copyParameters = new HashMap();
        for (Object key : actualParameters.keySet()) {
            Object actualParameter = actualParameters.get(key);
            Object copyParameter = ParameterUtil.copyParameter(actualParameter);
            copyParameters.put(key, copyParameter);
        }
        return copyParameters;
    }
}

