/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.jdbc;

import com.mockrunner.jdbc.ResultSetFactory;
import com.mockrunner.mock.jdbc.MockResultSet;
import com.mockrunner.util.common.FileUtil;
import com.mockrunner.util.common.StringUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FileResultSetFactory
implements ResultSetFactory {
    private File file = null;
    private String delimiter = ";";
    private boolean firstLineContainsColumnNames = false;
    private boolean trim = true;
    private boolean useTemplates = false;
    private String templateMarker = null;
    private Map templates = null;

    public FileResultSetFactory(String fileName) {
        this(new File(fileName));
    }

    public FileResultSetFactory(File file) {
        this.file = file;
        this.setDefaultTemplateConfiguration();
    }

    public File getFile() {
        if (this.file.exists() && this.file.isFile()) {
            return this.file;
        }
        try {
            this.file = FileUtil.findFile((String)this.file.getPath());
        }
        catch (FileNotFoundException exc) {
            throw new RuntimeException("Could not find: " + this.file.getPath() + ". Current dir = " + System.getProperty("user.dir"));
        }
        return this.file;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public void setFirstLineContainsColumnNames(boolean firstLineContainsColumnNames) {
        this.firstLineContainsColumnNames = firstLineContainsColumnNames;
    }

    public void setTrim(boolean trim) {
        this.trim = trim;
    }

    public void setUseTemplates(boolean useTemplates) {
        this.useTemplates = useTemplates;
    }

    public void setTemplateConfiguration(String marker, Map templates) {
        this.templates = templates;
        this.templateMarker = marker;
    }

    public void setDefaultTemplateConfiguration() {
        HashMap<String, String> templates = new HashMap<String, String>();
        templates.put("defaultString", "");
        templates.put("defaultDate", "1970-01-01");
        templates.put("defaultInteger", "0");
        this.setTemplateConfiguration("$", templates);
    }

    public MockResultSet create(String id) {
        MockResultSet resultSet = new MockResultSet(id);
        File fileToRead = this.getFile();
        List lines = FileUtil.getLinesFromFile((File)fileToRead);
        if (lines.size() == 0) {
            return resultSet;
        }
        int firstLineNumber = 0;
        if (this.firstLineContainsColumnNames) {
            String firstLine = (String)lines.get(firstLineNumber);
            ++firstLineNumber;
            String[] names = StringUtil.split((String)firstLine, (String)this.delimiter, (boolean)this.trim);
            for (int ii = 0; ii < names.length; ++ii) {
                resultSet.addColumn(names[ii]);
            }
        }
        for (int ii = firstLineNumber; ii < lines.size(); ++ii) {
            String line = (String)lines.get(ii);
            Object[] values = StringUtil.split((String)line, (String)this.delimiter, (boolean)this.trim);
            if (this.useTemplates) {
                for (int yy = 0; yy < values.length; ++yy) {
                    if (null == values[yy] || !((String)values[yy]).startsWith(this.templateMarker) || !this.templates.containsKey(((String)values[yy]).substring(1))) continue;
                    values[yy] = (String)this.templates.get(((String)values[yy]).substring(1));
                }
            }
            resultSet.addRow(values);
        }
        return resultSet;
    }
}

