/*
 * Decompiled with CFR 0.152.
 */
package com.marcosbarbero.cloud.autoconfigure.zuul.ratelimit.config;

import com.marcosbarbero.cloud.autoconfigure.zuul.ratelimit.config.RateLimitKeyGenerator;
import com.marcosbarbero.cloud.autoconfigure.zuul.ratelimit.config.properties.RateLimitProperties;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.StringJoiner;
import javax.servlet.http.HttpServletRequest;
import org.springframework.cloud.netflix.zuul.filters.Route;

public class DefaultRateLimitKeyGenerator
implements RateLimitKeyGenerator {
    private static final String ANONYMOUS_USER = "anonymous";
    private final RateLimitProperties properties;

    @Override
    public String key(HttpServletRequest request, Route route, RateLimitProperties.Policy policy) {
        List<RateLimitProperties.Policy.Type> types = policy.getType();
        StringJoiner joiner = new StringJoiner(":");
        joiner.add(this.properties.getKeyPrefix());
        if (route != null) {
            joiner.add(route.getId());
        }
        if (!types.isEmpty()) {
            if (types.contains((Object)RateLimitProperties.Policy.Type.URL) && route != null) {
                joiner.add(route.getPath());
            }
            if (types.contains((Object)RateLimitProperties.Policy.Type.ORIGIN)) {
                joiner.add(this.getRemoteAddress(request));
            }
            if (types.contains((Object)RateLimitProperties.Policy.Type.USER)) {
                joiner.add(request.getRemoteUser() != null ? request.getRemoteUser() : ANONYMOUS_USER);
            }
        }
        return joiner.toString();
    }

    private String getRemoteAddress(HttpServletRequest request) {
        String xForwardedFor = request.getHeader("X-Forwarded-For");
        if (this.properties.isBehindProxy() && xForwardedFor != null) {
            return xForwardedFor;
        }
        return request.getRemoteAddr();
    }

    @ConstructorProperties(value={"properties"})
    public DefaultRateLimitKeyGenerator(RateLimitProperties properties) {
        this.properties = properties;
    }
}

