/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.storage.file;

import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.Channels;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import org.eclipse.jgit.errors.ObjectWritingException;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.storage.file.FileObjectDatabase;
import org.eclipse.jgit.storage.file.ObjectDirectoryPackParser;
import org.eclipse.jgit.storage.file.WriteConfig;
import org.eclipse.jgit.transport.PackParser;
import org.eclipse.jgit.util.FileUtils;
import org.eclipse.jgit.util.IO;

class ObjectDirectoryInserter
extends ObjectInserter {
    private final FileObjectDatabase db;
    private final WriteConfig config;
    private Deflater deflate;

    ObjectDirectoryInserter(FileObjectDatabase dest, Config cfg) {
        this.db = dest;
        this.config = cfg.get(WriteConfig.KEY);
    }

    public ObjectId insert(int type, byte[] data, int off, int len) throws IOException {
        ObjectId id = this.idFor(type, data, off, len);
        if (this.db.has(id)) {
            return id;
        }
        File tmp = this.toTemp(type, data, off, len);
        return this.insertOneObject(tmp, id);
    }

    public ObjectId insert(int type, long len, InputStream is) throws IOException {
        if (len <= (long)this.buffer().length) {
            byte[] buf = this.buffer();
            IO.readFully(is, buf, 0, (int)len);
            return this.insert(type, buf, 0, (int)len);
        }
        MessageDigest md = this.digest();
        File tmp = this.toTemp(md, type, len, is);
        ObjectId id = ObjectId.fromRaw(md.digest());
        return this.insertOneObject(tmp, id);
    }

    private ObjectId insertOneObject(File tmp, ObjectId id) throws IOException, ObjectWritingException {
        switch (this.db.insertUnpackedObject(tmp, id, false)) {
            case INSERTED: 
            case EXISTS_PACKED: 
            case EXISTS_LOOSE: {
                return id;
            }
        }
        File dst = this.db.fileFor(id);
        throw new ObjectWritingException("Unable to create new object: " + dst);
    }

    public PackParser newPackParser(InputStream in) throws IOException {
        return new ObjectDirectoryPackParser(this.db, in);
    }

    public void flush() throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        if (this.deflate != null) {
            try {
                this.deflate.end();
                Object var2_1 = null;
                this.deflate = null;
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                this.deflate = null;
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private File toTemp(MessageDigest md, int type, long len, InputStream is) throws IOException, FileNotFoundException, Error {
        File file;
        boolean delete = true;
        File tmp = this.newTempFile();
        try {
            FileOutputStream fOut;
            block8: {
                fOut = new FileOutputStream(tmp);
                try {
                    void var9_10;
                    FileOutputStream fileOutputStream = fOut;
                    if (this.config.getFSyncObjectFiles()) {
                        OutputStream outputStream = Channels.newOutputStream(fOut.getChannel());
                    }
                    DeflaterOutputStream cOut = this.compress((OutputStream)var9_10);
                    DigestOutputStream dOut = new DigestOutputStream(cOut, md);
                    this.writeHeader(dOut, type, len);
                    byte[] buf = this.buffer();
                    while (len > 0L) {
                        int n = is.read(buf, 0, (int)Math.min(len, (long)buf.length));
                        if (n <= 0) {
                            throw ObjectDirectoryInserter.shortInput(len);
                        }
                        dOut.write(buf, 0, n);
                        len -= (long)n;
                    }
                    dOut.flush();
                    cOut.finish();
                    Object var15_16 = null;
                    if (!this.config.getFSyncObjectFiles()) break block8;
                }
                catch (Throwable throwable) {
                    Object var15_17 = null;
                    if (this.config.getFSyncObjectFiles()) {
                        fOut.getChannel().force(true);
                    }
                    fOut.close();
                    throw throwable;
                }
                fOut.getChannel().force(true);
            }
            fOut.close();
            delete = false;
            file = tmp;
            Object var17_19 = null;
            if (!delete) return file;
        }
        catch (Throwable throwable) {
            Object var17_20 = null;
            if (!delete) throw throwable;
            FileUtils.delete(tmp);
            throw throwable;
        }
        FileUtils.delete(tmp);
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private File toTemp(int type, byte[] buf, int pos, int len) throws IOException, FileNotFoundException {
        File file;
        boolean delete = true;
        File tmp = this.newTempFile();
        try {
            FileOutputStream fOut;
            block6: {
                fOut = new FileOutputStream(tmp);
                try {
                    void var8_10;
                    FileOutputStream fileOutputStream = fOut;
                    if (this.config.getFSyncObjectFiles()) {
                        OutputStream outputStream = Channels.newOutputStream(fOut.getChannel());
                    }
                    DeflaterOutputStream cOut = this.compress((OutputStream)var8_10);
                    this.writeHeader(cOut, type, len);
                    cOut.write(buf, pos, len);
                    cOut.finish();
                    Object var11_13 = null;
                    if (!this.config.getFSyncObjectFiles()) break block6;
                }
                catch (Throwable throwable) {
                    Object var11_14 = null;
                    if (this.config.getFSyncObjectFiles()) {
                        fOut.getChannel().force(true);
                    }
                    fOut.close();
                    throw throwable;
                }
                fOut.getChannel().force(true);
            }
            fOut.close();
            delete = false;
            file = tmp;
            Object var13_16 = null;
            if (!delete) return file;
        }
        catch (Throwable throwable) {
            Object var13_17 = null;
            if (!delete) throw throwable;
            FileUtils.delete(tmp);
            throw throwable;
        }
        FileUtils.delete(tmp);
        return file;
    }

    void writeHeader(OutputStream out, int type, long len) throws IOException {
        out.write(Constants.encodedTypeString(type));
        out.write(32);
        out.write(Constants.encodeASCII(len));
        out.write(0);
    }

    File newTempFile() throws IOException {
        return File.createTempFile("noz", null, this.db.getDirectory());
    }

    DeflaterOutputStream compress(OutputStream out) {
        if (this.deflate == null) {
            this.deflate = new Deflater(this.config.getCompression());
        } else {
            this.deflate.reset();
        }
        return new DeflaterOutputStream(out, this.deflate, 8192);
    }

    private static EOFException shortInput(long missing) {
        return new EOFException("Input did not match supplied length. " + missing + " bytes are missing.");
    }
}

